/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import java.util.Arrays;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.StatsCollectorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.AbstractColumnStatisticsCollector;

public class DoubleColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private Double min = null;
    private Double max = null;
    private final DoubleSet rawDoubleSet = new DoubleOpenHashSet(1000);
    private final DoubleSet aggregatedDoubleSet = new DoubleOpenHashSet(1000);
    private double[] sortedDoubleList;
    private boolean sealed = false;

    public DoubleColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    private void collectEntry(Object entry, DoubleSet set) {
        if (entry instanceof Object[]) {
            for (Object e : (Object[])entry) {
                set.add(((Number)e).doubleValue());
            }
            if (this.maxNumberOfMultiValues < ((Object[])entry).length) {
                this.maxNumberOfMultiValues = ((Object[])entry).length;
            }
            this.updateTotalNumberOfEntries((Object[])entry);
        } else {
            double value = ((Number)entry).doubleValue();
            this.addressSorted(value);
            this.updatePartition(value);
            set.add(value);
            ++this.totalNumberOfEntries;
        }
    }

    @Override
    public void collect(Object entry, boolean isAggregated) {
        if (isAggregated) {
            this.collectEntry(entry, this.aggregatedDoubleSet);
        } else {
            this.collectEntry(entry, this.rawDoubleSet);
        }
    }

    @Override
    public void collect(Object entry) {
        this.collect(entry, false);
    }

    @Override
    public Double getMinValue() {
        if (this.sealed) {
            return this.min;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public Double getMaxValue() {
        if (this.sealed) {
            return this.max;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public Object getUniqueValuesSet() {
        if (this.sealed) {
            return this.sortedDoubleList;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public int getCardinality() {
        if (this.sealed) {
            return this.sortedDoubleList.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public boolean hasNull() {
        return false;
    }

    @Override
    public void seal() {
        this.sealed = true;
        this.sortedDoubleList = new double[this.rawDoubleSet.size()];
        this.rawDoubleSet.toArray(this.sortedDoubleList);
        Arrays.sort(this.sortedDoubleList);
        if (this.sortedDoubleList.length == 0) {
            this.min = null;
            this.max = null;
            return;
        }
        this.min = this.sortedDoubleList[0];
        this.max = this.sortedDoubleList[this.sortedDoubleList.length - 1];
        int numAggregated = this.aggregatedDoubleSet.size();
        if (numAggregated > 0) {
            this.rawDoubleSet.addAll((DoubleCollection)this.aggregatedDoubleSet);
            this.sortedDoubleList = new double[this.rawDoubleSet.size()];
            this.rawDoubleSet.toArray(this.sortedDoubleList);
            Arrays.sort(this.sortedDoubleList);
        }
    }
}

