/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import java.util.Arrays;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.StatsCollectorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.AbstractColumnStatisticsCollector;

public class FloatColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private Float min = Float.valueOf(Float.MAX_VALUE);
    private Float max = Float.valueOf(Float.MIN_VALUE);
    private final FloatSet rawFloatSet = new FloatOpenHashSet(1000);
    private final FloatSet aggregatedFloatSet = new FloatOpenHashSet(1000);
    private float[] sortedFloatList;
    private boolean sealed = false;

    public FloatColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    private void collectEntry(Object entry, FloatSet set) {
        if (entry instanceof Object[]) {
            for (Object e : (Object[])entry) {
                set.add(((Number)e).floatValue());
            }
            if (this.maxNumberOfMultiValues < ((Object[])entry).length) {
                this.maxNumberOfMultiValues = ((Object[])entry).length;
            }
            this.updateTotalNumberOfEntries((Object[])entry);
        } else {
            float value = ((Number)entry).floatValue();
            this.addressSorted(Float.valueOf(value));
            this.updatePartition(Float.valueOf(value));
            set.add(value);
            ++this.totalNumberOfEntries;
        }
    }

    @Override
    public void collect(Object entry, boolean isAggregated) {
        if (isAggregated) {
            this.collectEntry(entry, this.aggregatedFloatSet);
        } else {
            this.collectEntry(entry, this.rawFloatSet);
        }
    }

    @Override
    public void collect(Object entry) {
        this.collect(entry, false);
    }

    @Override
    public Float getMinValue() {
        if (this.sealed) {
            return this.min;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public Float getMaxValue() {
        if (this.sealed) {
            return this.max;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public Object getUniqueValuesSet() {
        if (this.sealed) {
            return this.sortedFloatList;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public int getCardinality() {
        if (this.sealed) {
            return this.sortedFloatList.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public boolean hasNull() {
        return false;
    }

    @Override
    public void seal() {
        this.sealed = true;
        this.sortedFloatList = new float[this.rawFloatSet.size()];
        this.rawFloatSet.toArray(this.sortedFloatList);
        Arrays.sort(this.sortedFloatList);
        if (this.sortedFloatList.length == 0) {
            this.min = null;
            this.max = null;
            return;
        }
        this.min = Float.valueOf(this.sortedFloatList[0]);
        this.max = Float.valueOf(this.sortedFloatList[this.sortedFloatList.length - 1]);
        int numAggregated = this.aggregatedFloatSet.size();
        if (numAggregated > 0) {
            this.rawFloatSet.addAll((FloatCollection)this.aggregatedFloatSet);
            this.sortedFloatList = new float[this.rawFloatSet.size()];
            this.rawFloatSet.toArray(this.sortedFloatList);
            Arrays.sort(this.sortedFloatList);
        }
    }
}

