/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.StatsCollectorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.AbstractColumnStatisticsCollector;

public class IntColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private Integer min = null;
    private Integer max = null;
    private final IntSet rawIntSet = new IntOpenHashSet(1000);
    private final IntSet aggregatedIntSet = new IntOpenHashSet(1000);
    private int[] sortedIntList;
    private boolean sealed = false;

    public IntColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    private void collectEntry(Object entry, IntSet set) {
        if (entry instanceof Object[]) {
            for (Object e : (Object[])entry) {
                set.add(((Number)e).intValue());
            }
            if (this.maxNumberOfMultiValues < ((Object[])entry).length) {
                this.maxNumberOfMultiValues = ((Object[])entry).length;
            }
            this.updateTotalNumberOfEntries((Object[])entry);
        } else {
            int value = ((Number)entry).intValue();
            this.addressSorted(value);
            this.updatePartition(value);
            set.add(value);
            ++this.totalNumberOfEntries;
        }
    }

    @Override
    public void collect(Object entry, boolean isAggregated) {
        if (isAggregated) {
            this.collectEntry(entry, this.aggregatedIntSet);
        } else {
            this.collectEntry(entry, this.rawIntSet);
        }
    }

    @Override
    public void collect(Object entry) {
        this.collect(entry, false);
    }

    @Override
    public Integer getMinValue() {
        if (this.sealed) {
            return this.min;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public Integer getMaxValue() {
        if (this.sealed) {
            return this.max;
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    @Override
    public Object getUniqueValuesSet() {
        if (this.sealed) {
            return this.sortedIntList;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique value set");
    }

    @Override
    public int getCardinality() {
        if (this.sealed) {
            return this.sortedIntList.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for cardinality");
    }

    @Override
    public boolean hasNull() {
        return false;
    }

    @Override
    public void seal() {
        this.sealed = true;
        this.sortedIntList = new int[this.rawIntSet.size()];
        this.rawIntSet.toArray(this.sortedIntList);
        Arrays.sort(this.sortedIntList);
        if (this.sortedIntList.length == 0) {
            this.min = null;
            this.max = null;
            return;
        }
        this.min = this.sortedIntList[0];
        this.max = this.sortedIntList[this.sortedIntList.length - 1];
        int numAggregated = this.aggregatedIntSet.size();
        if (numAggregated > 0) {
            this.rawIntSet.addAll((IntCollection)this.aggregatedIntSet);
            this.sortedIntList = new int[this.rawIntSet.size()];
            this.rawIntSet.toArray(this.sortedIntList);
            Arrays.sort(this.sortedIntList);
        }
    }
}

