/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.column;

import java.io.IOException;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.DataFileReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.SingleColumnSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.FixedBitMultiValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.FixedBitSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.FixedByteChunkSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.SortedIndexReaderImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.VarByteChunkSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.ColumnMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.column.ColumnIndexContainer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.BitmapInvertedIndexReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.BloomFilterReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.BytesDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.DoubleDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.FloatDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.ImmutableDictionaryReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.IntDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.LongDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.OnHeapDoubleDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.OnHeapFloatDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.OnHeapIntDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.OnHeapLongDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.OnHeapStringDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.StringDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.ColumnIndexType;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.SegmentDirectory;
import org.apache.pinot.common.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhysicalColumnIndexContainer
implements ColumnIndexContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhysicalColumnIndexContainer.class);
    private final DataFileReader _forwardIndex;
    private final InvertedIndexReader _invertedIndex;
    private final ImmutableDictionaryReader _dictionary;
    private final BloomFilterReader _bloomFilterReader;

    public PhysicalColumnIndexContainer(SegmentDirectory.Reader segmentReader, ColumnMetadata metadata, IndexLoadingConfig indexLoadingConfig) throws IOException {
        String columnName = metadata.getColumnName();
        boolean loadInvertedIndex = false;
        boolean loadOnHeapDictionary = false;
        boolean loadBloomFilter = false;
        if (indexLoadingConfig != null) {
            loadInvertedIndex = indexLoadingConfig.getInvertedIndexColumns().contains(columnName);
            loadOnHeapDictionary = indexLoadingConfig.getOnHeapDictionaryColumns().contains(columnName);
            loadBloomFilter = indexLoadingConfig.getBloomFilterColumns().contains(columnName);
        }
        PinotDataBuffer fwdIndexBuffer = segmentReader.getIndexFor(columnName, ColumnIndexType.FORWARD_INDEX);
        if (metadata.hasDictionary()) {
            if (loadBloomFilter) {
                PinotDataBuffer bloomFilterBuffer = segmentReader.getIndexFor(columnName, ColumnIndexType.BLOOM_FILTER);
                this._bloomFilterReader = new BloomFilterReader(bloomFilterBuffer);
            } else {
                this._bloomFilterReader = null;
            }
            this._dictionary = PhysicalColumnIndexContainer.loadDictionary(segmentReader.getIndexFor(columnName, ColumnIndexType.DICTIONARY), metadata, loadOnHeapDictionary);
            if (metadata.isSingleValue()) {
                if (metadata.isSorted()) {
                    SortedIndexReaderImpl sortedIndexReader = new SortedIndexReaderImpl(fwdIndexBuffer, metadata.getCardinality());
                    this._forwardIndex = sortedIndexReader;
                    this._invertedIndex = sortedIndexReader;
                    return;
                }
                this._forwardIndex = new FixedBitSingleValueReader(fwdIndexBuffer, metadata.getTotalDocs(), metadata.getBitsPerElement());
            } else {
                this._forwardIndex = new FixedBitMultiValueReader(fwdIndexBuffer, metadata.getTotalDocs(), metadata.getTotalNumberOfEntries(), metadata.getBitsPerElement());
            }
            this._invertedIndex = loadInvertedIndex ? new BitmapInvertedIndexReader(segmentReader.getIndexFor(columnName, ColumnIndexType.INVERTED_INDEX), metadata.getCardinality()) : null;
        } else {
            this._forwardIndex = PhysicalColumnIndexContainer.loadRawForwardIndex(fwdIndexBuffer, metadata.getDataType());
            this._invertedIndex = null;
            this._dictionary = null;
            this._bloomFilterReader = null;
        }
    }

    @Override
    public DataFileReader getForwardIndex() {
        return this._forwardIndex;
    }

    @Override
    public InvertedIndexReader getInvertedIndex() {
        return this._invertedIndex;
    }

    @Override
    public ImmutableDictionaryReader getDictionary() {
        return this._dictionary;
    }

    @Override
    public BloomFilterReader getBloomFilter() {
        return this._bloomFilterReader;
    }

    private static ImmutableDictionaryReader loadDictionary(PinotDataBuffer dictionaryBuffer, ColumnMetadata metadata, boolean loadOnHeap) {
        FieldSpec.DataType dataType = metadata.getDataType();
        if (loadOnHeap) {
            String columnName = metadata.getColumnName();
            LOGGER.info("Loading on-heap dictionary for column: {}", (Object)columnName);
        }
        int length = metadata.getCardinality();
        switch (dataType) {
            case INT: {
                return loadOnHeap ? new OnHeapIntDictionary(dictionaryBuffer, length) : new IntDictionary(dictionaryBuffer, length);
            }
            case LONG: {
                return loadOnHeap ? new OnHeapLongDictionary(dictionaryBuffer, length) : new LongDictionary(dictionaryBuffer, length);
            }
            case FLOAT: {
                return loadOnHeap ? new OnHeapFloatDictionary(dictionaryBuffer, length) : new FloatDictionary(dictionaryBuffer, length);
            }
            case DOUBLE: {
                return loadOnHeap ? new OnHeapDoubleDictionary(dictionaryBuffer, length) : new DoubleDictionary(dictionaryBuffer, length);
            }
            case STRING: {
                int numBytesPerValue = metadata.getColumnMaxLength();
                byte paddingByte = (byte)metadata.getPaddingCharacter();
                return loadOnHeap ? new OnHeapStringDictionary(dictionaryBuffer, length, numBytesPerValue, paddingByte) : new StringDictionary(dictionaryBuffer, length, numBytesPerValue, paddingByte);
            }
            case BYTES: {
                int numBytesPerValue = metadata.getColumnMaxLength();
                return new BytesDictionary(dictionaryBuffer, length, numBytesPerValue);
            }
        }
        throw new IllegalStateException("Illegal data type for dictionary: " + (Object)((Object)dataType));
    }

    private static SingleColumnSingleValueReader loadRawForwardIndex(PinotDataBuffer forwardIndexBuffer, FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new FixedByteChunkSingleValueReader(forwardIndexBuffer);
            }
            case STRING: 
            case BYTES: {
                return new VarByteChunkSingleValueReader(forwardIndexBuffer);
            }
        }
        throw new IllegalStateException("Illegal data type for raw forward index: " + (Object)((Object)dataType));
    }
}

