/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.config.InstanceDataManagerConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGeneratorMode;
import org.apache.pinot.common.config.IndexingConfig;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.segment.ReadMode;

public class IndexLoadingConfig {
    private static final int DEFAULT_REALTIME_AVG_MULTI_VALUE_COUNT = 2;
    private ReadMode _readMode = ReadMode.DEFAULT_MODE;
    private List<String> _sortedColumns = Collections.emptyList();
    private Set<String> _invertedIndexColumns = new HashSet<String>();
    private Set<String> _noDictionaryColumns = new HashSet<String>();
    private Map<String, String> _noDictionaryConfig = new HashMap<String, String>();
    private Set<String> _onHeapDictionaryColumns = new HashSet<String>();
    private Set<String> _bloomFilterColumns = new HashSet<String>();
    private SegmentVersion _segmentVersion;
    private boolean _enableDefaultColumns = true;
    private ColumnMinMaxValueGeneratorMode _columnMinMaxValueGeneratorMode = ColumnMinMaxValueGeneratorMode.DEFAULT_MODE;
    private int _realtimeAvgMultiValueCount = 2;
    private boolean _enableSplitCommit;
    private boolean _isRealtimeOffheapAllocation;
    private boolean _isDirectRealtimeOffheapAllocation;

    public IndexLoadingConfig(@Nonnull InstanceDataManagerConfig instanceDataManagerConfig, @Nonnull TableConfig tableConfig) {
        this.extractFromInstanceConfig(instanceDataManagerConfig);
        this.extractFromTableConfig(tableConfig);
    }

    private void extractFromTableConfig(@Nonnull TableConfig tableConfig) {
        String columnMinMaxValueGeneratorMode;
        String tableSegmentVersion;
        List<String> onHeapDictionaryColumns;
        Map<String, String> noDictionaryConfig;
        List<String> noDictionaryColumns;
        List<String> bloomFilterColumns;
        List<String> invertedIndexColumns;
        List<String> sortedColumns;
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        String tableReadMode = indexingConfig.getLoadMode();
        if (tableReadMode != null) {
            this._readMode = ReadMode.getEnum(tableReadMode);
        }
        if ((sortedColumns = indexingConfig.getSortedColumn()) != null) {
            this._sortedColumns = sortedColumns;
        }
        if ((invertedIndexColumns = indexingConfig.getInvertedIndexColumns()) != null) {
            this._invertedIndexColumns.addAll(invertedIndexColumns);
        }
        if ((bloomFilterColumns = indexingConfig.getBloomFilterColumns()) != null) {
            this._bloomFilterColumns.addAll(bloomFilterColumns);
        }
        if ((noDictionaryColumns = indexingConfig.getNoDictionaryColumns()) != null) {
            this._noDictionaryColumns.addAll(noDictionaryColumns);
        }
        if ((noDictionaryConfig = indexingConfig.getNoDictionaryConfig()) != null) {
            this._noDictionaryConfig.putAll(noDictionaryConfig);
        }
        if ((onHeapDictionaryColumns = indexingConfig.getOnHeapDictionaryColumns()) != null) {
            this._onHeapDictionaryColumns.addAll(onHeapDictionaryColumns);
        }
        if ((tableSegmentVersion = indexingConfig.getSegmentFormatVersion()) != null) {
            this._segmentVersion = SegmentVersion.valueOf(tableSegmentVersion.toLowerCase());
        }
        if ((columnMinMaxValueGeneratorMode = indexingConfig.getColumnMinMaxValueGeneratorMode()) != null) {
            this._columnMinMaxValueGeneratorMode = ColumnMinMaxValueGeneratorMode.valueOf(columnMinMaxValueGeneratorMode.toUpperCase());
        }
    }

    private void extractFromInstanceConfig(@Nonnull InstanceDataManagerConfig instanceDataManagerConfig) {
        String instanceSegmentVersion;
        ReadMode instanceReadMode = instanceDataManagerConfig.getReadMode();
        if (instanceReadMode != null) {
            this._readMode = instanceReadMode;
        }
        if ((instanceSegmentVersion = instanceDataManagerConfig.getSegmentFormatVersion()) != null) {
            this._segmentVersion = SegmentVersion.valueOf(instanceSegmentVersion.toLowerCase());
        }
        this._enableDefaultColumns = instanceDataManagerConfig.isEnableDefaultColumns();
        this._enableSplitCommit = instanceDataManagerConfig.isEnableSplitCommit();
        this._isRealtimeOffheapAllocation = instanceDataManagerConfig.isRealtimeOffHeapAllocation();
        this._isDirectRealtimeOffheapAllocation = instanceDataManagerConfig.isDirectRealtimeOffheapAllocation();
        String avgMultiValueCount = instanceDataManagerConfig.getAvgMultiValueCount();
        if (avgMultiValueCount != null) {
            this._realtimeAvgMultiValueCount = Integer.valueOf(avgMultiValueCount);
        }
    }

    public IndexLoadingConfig() {
    }

    @Nonnull
    public ReadMode getReadMode() {
        return this._readMode;
    }

    public void setReadMode(@Nonnull ReadMode readMode) {
        this._readMode = readMode;
    }

    @Nonnull
    public List<String> getSortedColumns() {
        return this._sortedColumns;
    }

    @Nonnull
    public Set<String> getInvertedIndexColumns() {
        return this._invertedIndexColumns;
    }

    @VisibleForTesting
    public void setInvertedIndexColumns(@Nonnull Set<String> invertedIndexColumns) {
        this._invertedIndexColumns = invertedIndexColumns;
    }

    @VisibleForTesting
    public void setBloomFilterColumns(@Nonnull Set<String> bloomFilterColumns) {
        this._bloomFilterColumns = bloomFilterColumns;
    }

    @VisibleForTesting
    public void setOnHeapDictionaryColumns(@Nonnull Set<String> onHeapDictionaryColumns) {
        this._onHeapDictionaryColumns = onHeapDictionaryColumns;
    }

    @Nonnull
    public Set<String> getNoDictionaryColumns() {
        return this._noDictionaryColumns;
    }

    @Nonnull
    public Map<String, String> getnoDictionaryConfig() {
        return this._noDictionaryConfig;
    }

    @Nonnull
    public Set<String> getOnHeapDictionaryColumns() {
        return this._onHeapDictionaryColumns;
    }

    public Set<String> getBloomFilterColumns() {
        return this._bloomFilterColumns;
    }

    @Nullable
    public SegmentVersion getSegmentVersion() {
        return this._segmentVersion;
    }

    public void setSegmentVersion(@Nonnull SegmentVersion segmentVersion) {
        this._segmentVersion = segmentVersion;
    }

    public boolean isEnableDefaultColumns() {
        return this._enableDefaultColumns;
    }

    public boolean isEnableSplitCommit() {
        return this._enableSplitCommit;
    }

    public boolean isRealtimeOffheapAllocation() {
        return this._isRealtimeOffheapAllocation;
    }

    public boolean isDirectRealtimeOffheapAllocation() {
        return this._isDirectRealtimeOffheapAllocation;
    }

    @Nonnull
    public ColumnMinMaxValueGeneratorMode getColumnMinMaxValueGeneratorMode() {
        return this._columnMinMaxValueGeneratorMode;
    }

    public void setColumnMinMaxValueGeneratorMode(ColumnMinMaxValueGeneratorMode columnMinMaxValueGeneratorMode) {
        this._columnMinMaxValueGeneratorMode = columnMinMaxValueGeneratorMode;
    }

    public int getRealtimeAvgMultiValueCount() {
        return this._realtimeAvgMultiValueCount;
    }
}

