/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.commons.io.FileUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.bloomfilter.BloomFilterHandler;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGenerator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGeneratorMode;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.defaultcolumn.DefaultColumnHandler;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.defaultcolumn.DefaultColumnHandlerFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.invertedindex.InvertedIndexHandler;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.SegmentDirectory;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.segment.ReadMode;

public class SegmentPreProcessor
implements AutoCloseable {
    private final File _indexDir;
    private final IndexLoadingConfig _indexLoadingConfig;
    private final Schema _schema;
    private final SegmentDirectory _segmentDirectory;
    private SegmentMetadataImpl _segmentMetadata;

    public SegmentPreProcessor(@Nonnull File indexDir, @Nonnull IndexLoadingConfig indexLoadingConfig, @Nullable Schema schema) throws Exception {
        this._indexDir = indexDir;
        this._indexLoadingConfig = indexLoadingConfig;
        this._schema = schema;
        this._segmentMetadata = new SegmentMetadataImpl(indexDir);
        this._segmentDirectory = SegmentDirectory.createFromLocalFS(indexDir, this._segmentMetadata, ReadMode.mmap);
    }

    public void process() throws Exception {
        if (this._segmentMetadata.getTotalDocs() == 0) {
            return;
        }
        File[] directoryListing = this._indexDir.listFiles();
        String tempFileExtension = ".bitmap.inv.tmp";
        if (directoryListing != null) {
            for (File child : directoryListing) {
                if (!child.getName().endsWith(tempFileExtension)) continue;
                FileUtils.deleteQuietly(child);
            }
        }
        try (SegmentDirectory.Writer segmentWriter = this._segmentDirectory.createWriter();){
            if (this._indexLoadingConfig.isEnableDefaultColumns() && this._schema != null) {
                DefaultColumnHandler defaultColumnHandler = DefaultColumnHandlerFactory.getDefaultColumnHandler(this._indexDir, this._schema, this._segmentMetadata, segmentWriter);
                defaultColumnHandler.updateDefaultColumns();
                this._segmentMetadata = new SegmentMetadataImpl(this._indexDir);
            }
            InvertedIndexHandler invertedIndexHandler = new InvertedIndexHandler(this._indexDir, this._segmentMetadata, this._indexLoadingConfig, segmentWriter);
            invertedIndexHandler.createInvertedIndices();
            BloomFilterHandler bloomFilterHandler = new BloomFilterHandler(this._indexDir, this._segmentMetadata, this._indexLoadingConfig, segmentWriter);
            bloomFilterHandler.createBloomFilters();
            ColumnMinMaxValueGeneratorMode columnMinMaxValueGeneratorMode = this._indexLoadingConfig.getColumnMinMaxValueGeneratorMode();
            if (columnMinMaxValueGeneratorMode != ColumnMinMaxValueGeneratorMode.NONE) {
                ColumnMinMaxValueGenerator columnMinMaxValueGenerator = new ColumnMinMaxValueGenerator(this._segmentMetadata, segmentWriter, columnMinMaxValueGeneratorMode);
                columnMinMaxValueGenerator.addColumnMinMaxValue();
            }
            segmentWriter.save();
        }
    }

    @Override
    public void close() throws Exception {
        this._segmentDirectory.close();
    }
}

