/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.bloomfilter;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.commons.io.FileUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.bloom.BloomFilterCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.ColumnMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.LoaderUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.invertedindex.InvertedIndexHandler;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.DoubleDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.FloatDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.ImmutableDictionaryReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.IntDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.LongDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.StringDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.ColumnIndexType;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.SegmentDirectory;
import org.apache.pinot.common.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilterHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvertedIndexHandler.class);
    private final File _indexDir;
    private final SegmentDirectory.Writer _segmentWriter;
    private final String _segmentName;
    private final SegmentVersion _segmentVersion;
    private final Set<ColumnMetadata> _bloomFilterColumns = new HashSet<ColumnMetadata>();

    public BloomFilterHandler(@Nonnull File indexDir, @Nonnull SegmentMetadataImpl segmentMetadata, @Nonnull IndexLoadingConfig indexLoadingConfig, @Nonnull SegmentDirectory.Writer segmentWriter) {
        this._indexDir = indexDir;
        this._segmentWriter = segmentWriter;
        this._segmentName = segmentMetadata.getName();
        this._segmentVersion = SegmentVersion.valueOf(segmentMetadata.getVersion());
        for (String column : indexLoadingConfig.getBloomFilterColumns()) {
            ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
            if (columnMetadata == null) continue;
            this._bloomFilterColumns.add(columnMetadata);
        }
    }

    public void createBloomFilters() throws Exception {
        for (ColumnMetadata columnMetadata : this._bloomFilterColumns) {
            if (!columnMetadata.hasDictionary()) continue;
            this.createBloomFilterForColumn(columnMetadata);
        }
    }

    private void createBloomFilterForColumn(ColumnMetadata columnMetadata) throws Exception {
        File bloomFilterFile;
        File bloomFilterFileInProgress;
        String columnName;
        block30: {
            columnName = columnMetadata.getColumnName();
            bloomFilterFileInProgress = new File(this._indexDir, columnName + ".bloom.inprogress");
            bloomFilterFile = new File(this._indexDir, columnName + ".bloom");
            if (!bloomFilterFileInProgress.exists()) {
                if (this._segmentWriter.hasIndexFor(columnName, ColumnIndexType.BLOOM_FILTER)) {
                    LOGGER.info("Found bloom filter for segment: {}, column: {}", (Object)this._segmentName, (Object)columnName);
                    return;
                }
                FileUtils.touch(bloomFilterFileInProgress);
            } else {
                FileUtils.deleteQuietly(bloomFilterFile);
            }
            LOGGER.info("Creating new bloom filter for segment: {}, column: {}", (Object)this._segmentName, (Object)columnName);
            try (BloomFilterCreator creator = new BloomFilterCreator(this._indexDir, columnName, columnMetadata.getCardinality());){
                if (columnMetadata.hasDictionary()) {
                    try (ImmutableDictionaryReader dictionaryReader = this.getDictionaryReader(columnMetadata, this._segmentWriter);){
                        for (int i = 0; i < dictionaryReader.length(); ++i) {
                            creator.add(dictionaryReader.get(i));
                        }
                        break block30;
                    }
                }
                throw new UnsupportedOperationException("Bloom filters not supported for no dictionary columns");
            }
        }
        if (this._segmentVersion == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(this._segmentWriter, columnName, bloomFilterFile, ColumnIndexType.BLOOM_FILTER);
        }
        FileUtils.deleteQuietly(bloomFilterFileInProgress);
        LOGGER.info("Created bloom filter for segment: {}, column: {}", (Object)this._segmentName, (Object)columnName);
    }

    private ImmutableDictionaryReader getDictionaryReader(ColumnMetadata columnMetadata, SegmentDirectory.Writer segmentWriter) throws IOException {
        ImmutableDictionaryReader dictionaryReader;
        PinotDataBuffer dictionaryBuffer = segmentWriter.getIndexFor(columnMetadata.getColumnName(), ColumnIndexType.DICTIONARY);
        int cardinality = columnMetadata.getCardinality();
        FieldSpec.DataType dataType = columnMetadata.getDataType();
        switch (dataType) {
            case INT: {
                dictionaryReader = new IntDictionary(dictionaryBuffer, cardinality);
                break;
            }
            case LONG: {
                dictionaryReader = new LongDictionary(dictionaryBuffer, cardinality);
                break;
            }
            case FLOAT: {
                dictionaryReader = new FloatDictionary(dictionaryBuffer, cardinality);
                break;
            }
            case DOUBLE: {
                dictionaryReader = new DoubleDictionary(dictionaryBuffer, cardinality);
                break;
            }
            case STRING: {
                dictionaryReader = new StringDictionary(dictionaryBuffer, cardinality, columnMetadata.getColumnMaxLength(), (byte)columnMetadata.getPaddingCharacter());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported data type: " + (Object)((Object)dataType) + " for column: " + columnMetadata.getColumnName());
            }
        }
        return dictionaryReader;
    }
}

