/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.columnminmaxvalue;

import com.clearspring.analytics.util.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGeneratorMode;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.DoubleDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.FloatDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.IntDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.LongDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.StringDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.ColumnIndexType;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.SegmentDirectory;
import org.apache.pinot.common.data.Schema;

public class ColumnMinMaxValueGenerator {
    private final SegmentMetadataImpl _segmentMetadata;
    private final PropertiesConfiguration _segmentProperties;
    private final SegmentDirectory.Writer _segmentWriter;
    private final ColumnMinMaxValueGeneratorMode _columnMinMaxValueGeneratorMode;
    private boolean _minMaxValueAdded;

    public ColumnMinMaxValueGenerator(SegmentMetadataImpl segmentMetadata, SegmentDirectory.Writer segmentWriter, ColumnMinMaxValueGeneratorMode columnMinMaxValueGeneratorMode) {
        this._segmentMetadata = segmentMetadata;
        this._segmentProperties = SegmentMetadataImpl.getPropertiesConfiguration(this._segmentMetadata.getIndexDir());
        this._segmentWriter = segmentWriter;
        this._columnMinMaxValueGeneratorMode = columnMinMaxValueGeneratorMode;
    }

    public void addColumnMinMaxValue() throws Exception {
        Preconditions.checkState((this._columnMinMaxValueGeneratorMode != ColumnMinMaxValueGeneratorMode.NONE ? 1 : 0) != 0);
        Schema schema = this._segmentMetadata.getSchema();
        String timeColumnName = schema.getTimeColumnName();
        if (timeColumnName != null) {
            this.addColumnMinMaxValueForColumn(timeColumnName);
        }
        if (this._columnMinMaxValueGeneratorMode == ColumnMinMaxValueGeneratorMode.TIME) {
            this.saveMetadata();
            return;
        }
        for (String dimensionColumnName : schema.getDimensionNames()) {
            this.addColumnMinMaxValueForColumn(dimensionColumnName);
        }
        if (this._columnMinMaxValueGeneratorMode == ColumnMinMaxValueGeneratorMode.NON_METRIC) {
            this.saveMetadata();
            return;
        }
        for (String metricColumnName : schema.getMetricNames()) {
            this.addColumnMinMaxValueForColumn(metricColumnName);
        }
        this.saveMetadata();
    }

    /*
     * Unable to fully structure code
     */
    private void addColumnMinMaxValueForColumn(String columnName) throws Exception {
        columnMetadata = this._segmentMetadata.getColumnMetadataFor(columnName);
        if (!columnMetadata.hasDictionary() || columnMetadata.getMinValue() != null) {
            return;
        }
        dictionaryBuffer = this._segmentWriter.getIndexFor(columnName, ColumnIndexType.DICTIONARY);
        dataType = columnMetadata.getDataType();
        length = columnMetadata.getCardinality();
        switch (1.$SwitchMap$org$apache$pinot$common$data$FieldSpec$DataType[dataType.ordinal()]) {
            case 1: {
                intDictionary = new IntDictionary(dictionaryBuffer, length);
                var7_11 = null;
                SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, intDictionary.getStringValue(0), intDictionary.getStringValue(length - 1));
                if (intDictionary == null) break;
                if (var7_11 == null) ** GOTO lbl21
                try {
                    intDictionary.close();
                }
                catch (Throwable var8_16) {
                    var7_11.addSuppressed(var8_16);
                }
                break;
lbl21:
                // 1 sources

                intDictionary.close();
                break;
                catch (Throwable var8_17) {
                    try {
                        var7_11 = var8_17;
                        throw var8_17;
                    }
                    catch (Throwable var9_26) {
                        if (intDictionary != null) {
                            if (var7_11 != null) {
                                try {
                                    intDictionary.close();
                                }
                                catch (Throwable var10_27) {
                                    var7_11.addSuppressed(var10_27);
                                }
                            } else {
                                intDictionary.close();
                            }
                        }
                        throw var9_26;
                    }
                }
            }
            case 2: {
                longDictionary = new LongDictionary(dictionaryBuffer, length);
                var7_12 = null;
                SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, longDictionary.getStringValue(0), longDictionary.getStringValue(length - 1));
                if (longDictionary == null) break;
                if (var7_12 == null) ** GOTO lbl51
                try {
                    longDictionary.close();
                }
                catch (Throwable var8_18) {
                    var7_12.addSuppressed(var8_18);
                }
                break;
lbl51:
                // 1 sources

                longDictionary.close();
                break;
                catch (Throwable var8_19) {
                    try {
                        var7_12 = var8_19;
                        throw var8_19;
                    }
                    catch (Throwable var11_28) {
                        if (longDictionary != null) {
                            if (var7_12 != null) {
                                try {
                                    longDictionary.close();
                                }
                                catch (Throwable var12_29) {
                                    var7_12.addSuppressed(var12_29);
                                }
                            } else {
                                longDictionary.close();
                            }
                        }
                        throw var11_28;
                    }
                }
            }
            case 3: {
                floatDictionary = new FloatDictionary(dictionaryBuffer, length);
                var7_13 = null;
                SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, floatDictionary.getStringValue(0), floatDictionary.getStringValue(length - 1));
                if (floatDictionary == null) break;
                if (var7_13 == null) ** GOTO lbl81
                try {
                    floatDictionary.close();
                }
                catch (Throwable var8_20) {
                    var7_13.addSuppressed(var8_20);
                }
                break;
lbl81:
                // 1 sources

                floatDictionary.close();
                break;
                catch (Throwable var8_21) {
                    try {
                        var7_13 = var8_21;
                        throw var8_21;
                    }
                    catch (Throwable var13_30) {
                        if (floatDictionary != null) {
                            if (var7_13 != null) {
                                try {
                                    floatDictionary.close();
                                }
                                catch (Throwable var14_31) {
                                    var7_13.addSuppressed(var14_31);
                                }
                            } else {
                                floatDictionary.close();
                            }
                        }
                        throw var13_30;
                    }
                }
            }
            case 4: {
                doubleDictionary = new DoubleDictionary(dictionaryBuffer, length);
                var7_14 = null;
                SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, doubleDictionary.getStringValue(0), doubleDictionary.getStringValue(length - 1));
                if (doubleDictionary == null) break;
                if (var7_14 == null) ** GOTO lbl111
                try {
                    doubleDictionary.close();
                }
                catch (Throwable var8_22) {
                    var7_14.addSuppressed(var8_22);
                }
                break;
lbl111:
                // 1 sources

                doubleDictionary.close();
                break;
                catch (Throwable var8_23) {
                    try {
                        var7_14 = var8_23;
                        throw var8_23;
                    }
                    catch (Throwable var15_32) {
                        if (doubleDictionary != null) {
                            if (var7_14 != null) {
                                try {
                                    doubleDictionary.close();
                                }
                                catch (Throwable var16_33) {
                                    var7_14.addSuppressed(var16_33);
                                }
                            } else {
                                doubleDictionary.close();
                            }
                        }
                        throw var15_32;
                    }
                }
            }
            case 5: {
                stringDictionary = new StringDictionary(dictionaryBuffer, length, columnMetadata.getColumnMaxLength(), (byte)columnMetadata.getPaddingCharacter());
                var7_15 = null;
                SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, stringDictionary.get(0), stringDictionary.get(length - 1));
                if (stringDictionary == null) break;
                if (var7_15 == null) ** GOTO lbl141
                try {
                    stringDictionary.close();
                }
                catch (Throwable var8_24) {
                    var7_15.addSuppressed(var8_24);
                }
                break;
lbl141:
                // 1 sources

                stringDictionary.close();
                break;
                catch (Throwable var8_25) {
                    try {
                        var7_15 = var8_25;
                        throw var8_25;
                    }
                    catch (Throwable var17_34) {
                        if (stringDictionary != null) {
                            if (var7_15 != null) {
                                try {
                                    stringDictionary.close();
                                }
                                catch (Throwable var18_35) {
                                    var7_15.addSuppressed(var18_35);
                                }
                            } else {
                                stringDictionary.close();
                            }
                        }
                        throw var17_34;
                    }
                }
            }
            default: {
                throw new IllegalStateException("Unsupported data type: " + (Object)dataType + " for column: " + columnName);
            }
        }
        this._minMaxValueAdded = true;
    }

    private void saveMetadata() throws Exception {
        if (this._minMaxValueAdded) {
            this._segmentProperties.save();
        }
    }
}

