/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.defaultcolumn;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.$internal.org.apache.commons.io.FileUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.ColumnIndexCreationInfo;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.ForwardIndexType;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.InvertedIndexType;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.SegmentDictionaryCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.fwd.MultiValueUnsortedForwardIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.fwd.SingleValueSortedForwardIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.ColumnMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.LoaderUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.defaultcolumn.DefaultColumnHandler;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.defaultcolumn.DefaultColumnStatistics;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDefaultColumnHandler
implements DefaultColumnHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDefaultColumnHandler.class);
    protected final File _indexDir;
    protected final Schema _schema;
    protected final SegmentMetadataImpl _segmentMetadata;
    private final PropertiesConfiguration _segmentProperties;

    protected BaseDefaultColumnHandler(File indexDir, Schema schema, SegmentMetadataImpl segmentMetadata) {
        this._indexDir = indexDir;
        this._schema = schema;
        this._segmentMetadata = segmentMetadata;
        this._segmentProperties = SegmentMetadataImpl.getPropertiesConfiguration(indexDir);
    }

    @Override
    public void updateDefaultColumns() throws Exception {
        Map<String, DefaultColumnAction> defaultColumnActionMap = this.computeDefaultColumnActionMap();
        if (defaultColumnActionMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, DefaultColumnAction> entry : defaultColumnActionMap.entrySet()) {
            this.updateDefaultColumn(entry.getKey(), entry.getValue());
        }
        List<String> dimensionColumns = LoaderUtils.getStringListFromSegmentProperties("segment.dimension.column.names", this._segmentProperties);
        List<String> metricColumns = LoaderUtils.getStringListFromSegmentProperties("segment.metric.column.names", this._segmentProperties);
        for (Map.Entry<String, DefaultColumnAction> entry : defaultColumnActionMap.entrySet()) {
            String column = entry.getKey();
            DefaultColumnAction action = entry.getValue();
            switch (action) {
                case ADD_DIMENSION: {
                    dimensionColumns.add(column);
                    break;
                }
                case ADD_METRIC: {
                    metricColumns.add(column);
                    break;
                }
                case REMOVE_DIMENSION: {
                    dimensionColumns.remove(column);
                    break;
                }
                case REMOVE_METRIC: {
                    metricColumns.remove(column);
                    break;
                }
            }
        }
        this._segmentProperties.setProperty("segment.dimension.column.names", dimensionColumns);
        this._segmentProperties.setProperty("segment.metric.column.names", metricColumns);
        File metadataFile = this._segmentProperties.getFile();
        File metadataBackUpFile = new File(metadataFile + ".bak");
        if (!metadataBackUpFile.exists()) {
            FileUtils.copyFile(metadataFile, metadataBackUpFile);
        }
        this._segmentProperties.save();
    }

    private Map<String, DefaultColumnAction> computeDefaultColumnActionMap() {
        HashMap<String, DefaultColumnAction> defaultColumnActionMap = new HashMap<String, DefaultColumnAction>();
        Set<String> columnsInSchema = this._schema.getPhysicalColumnNames();
        block4: for (String column : columnsInSchema) {
            FieldSpec fieldSpecInSchema = this._schema.getFieldSpecFor(column);
            Preconditions.checkNotNull(fieldSpecInSchema);
            FieldSpec.FieldType fieldTypeInSchema = fieldSpecInSchema.getFieldType();
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (columnMetadata != null) {
                if (!columnMetadata.isAutoGenerated()) continue;
                FieldSpec.FieldType fieldTypeInMetadata = columnMetadata.getFieldType();
                if (fieldTypeInMetadata != fieldTypeInSchema) {
                    String failureMessage = "Field type: " + (Object)((Object)fieldTypeInMetadata) + " for auto-generated column: " + column + " does not match field type: " + (Object)((Object)fieldTypeInSchema) + " in schema, throw exception to drop and re-download the segment.";
                    throw new RuntimeException(failureMessage);
                }
                FieldSpec.DataType dataTypeInMetadata = columnMetadata.getDataType();
                FieldSpec.DataType dataTypeInSchema = fieldSpecInSchema.getDataType();
                boolean isSingleValueInMetadata = columnMetadata.isSingleValue();
                boolean isSingleValueInSchema = fieldSpecInSchema.isSingleValueField();
                String defaultValueInMetadata = columnMetadata.getDefaultNullValueString();
                String defaultValueInSchema = fieldSpecInSchema.getDefaultNullValue().toString();
                if (dataTypeInMetadata == dataTypeInSchema && isSingleValueInMetadata == isSingleValueInSchema && defaultValueInSchema.equals(defaultValueInMetadata)) continue;
                if (fieldTypeInMetadata == FieldSpec.FieldType.DIMENSION) {
                    defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DIMENSION);
                    continue;
                }
                Preconditions.checkState(fieldTypeInMetadata == FieldSpec.FieldType.METRIC);
                defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_METRIC);
                continue;
            }
            switch (fieldTypeInSchema) {
                case DIMENSION: {
                    defaultColumnActionMap.put(column, DefaultColumnAction.ADD_DIMENSION);
                    continue block4;
                }
                case METRIC: {
                    defaultColumnActionMap.put(column, DefaultColumnAction.ADD_METRIC);
                    continue block4;
                }
            }
            LOGGER.warn("Skip adding default column for column: {} with field type: {}", (Object)column, (Object)fieldTypeInSchema);
        }
        Set<String> columnsInMetadata = this._segmentMetadata.getAllColumns();
        for (String column : columnsInMetadata) {
            ColumnMetadata columnMetadata;
            if (columnsInSchema.contains(column) || !(columnMetadata = this._segmentMetadata.getColumnMetadataFor(column)).isAutoGenerated()) continue;
            FieldSpec.FieldType fieldTypeInMetadata = columnMetadata.getFieldType();
            if (fieldTypeInMetadata == FieldSpec.FieldType.DIMENSION) {
                defaultColumnActionMap.put(column, DefaultColumnAction.REMOVE_DIMENSION);
                continue;
            }
            Preconditions.checkState(fieldTypeInMetadata == FieldSpec.FieldType.METRIC);
            defaultColumnActionMap.put(column, DefaultColumnAction.REMOVE_METRIC);
        }
        return defaultColumnActionMap;
    }

    protected abstract void updateDefaultColumn(String var1, DefaultColumnAction var2) throws Exception;

    protected void removeColumnV1Indices(String column) throws IOException {
        FileUtils.forceDelete(new File(this._indexDir, column + ".dict"));
        File svFwdIndex = new File(this._indexDir, column + ".sv.sorted.fwd");
        if (svFwdIndex.exists()) {
            FileUtils.forceDelete(svFwdIndex);
        } else {
            FileUtils.forceDelete(new File(this._indexDir, column + ".mv.fwd"));
        }
        SegmentColumnarIndexCreator.removeColumnMetadataInfo(this._segmentProperties, column);
    }

    protected void createColumnV1Indices(String column) throws Exception {
        Object[] sortedArray;
        FieldSpec fieldSpec = this._schema.getFieldSpecFor(column);
        Preconditions.checkNotNull(fieldSpec);
        int totalDocs = this._segmentMetadata.getTotalDocs();
        int totalRawDocs = this._segmentMetadata.getTotalRawDocs();
        int totalAggDocs = totalDocs - totalRawDocs;
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        Object defaultValue = fieldSpec.getDefaultNullValue();
        boolean isSingleValue = fieldSpec.isSingleValueField();
        int maxNumberOfMultiValueElements = isSingleValue ? 0 : 1;
        int dictionaryElementSize = 0;
        switch (dataType) {
            case INT: {
                Preconditions.checkState(defaultValue instanceof Integer);
                sortedArray = new int[]{(Integer)defaultValue};
                break;
            }
            case LONG: {
                Preconditions.checkState(defaultValue instanceof Long);
                sortedArray = new long[]{(Long)defaultValue};
                break;
            }
            case FLOAT: {
                Preconditions.checkState(defaultValue instanceof Float);
                sortedArray = new float[]{((Float)defaultValue).floatValue()};
                break;
            }
            case DOUBLE: {
                Preconditions.checkState(defaultValue instanceof Double);
                sortedArray = new double[]{(Double)defaultValue};
                break;
            }
            case STRING: {
                Preconditions.checkState(defaultValue instanceof String);
                String stringDefaultValue = (String)defaultValue;
                dictionaryElementSize = StringUtil.encodeUtf8(stringDefaultValue).length;
                sortedArray = new String[]{stringDefaultValue};
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)dataType) + " for column: " + column);
            }
        }
        DefaultColumnStatistics columnStatistics = new DefaultColumnStatistics(defaultValue, defaultValue, sortedArray, isSingleValue, totalDocs, maxNumberOfMultiValueElements);
        ColumnIndexCreationInfo columnIndexCreationInfo = new ColumnIndexCreationInfo(columnStatistics, true, ForwardIndexType.FIXED_BIT_COMPRESSED, InvertedIndexType.SORTED_INDEX, true, defaultValue);
        try (SegmentDictionaryCreator creator = new SegmentDictionaryCreator(sortedArray, fieldSpec, this._indexDir);){
            creator.build();
        }
        if (isSingleValue) {
            SingleValueSortedForwardIndexCreator svFwdIndexCreator = new SingleValueSortedForwardIndexCreator(this._indexDir, fieldSpec.getName(), 1);
            for (int docId = 0; docId < totalDocs; ++docId) {
                svFwdIndexCreator.index(docId, 0);
            }
            svFwdIndexCreator.close();
        } else {
            MultiValueUnsortedForwardIndexCreator mvFwdIndexCreator = new MultiValueUnsortedForwardIndexCreator(this._indexDir, fieldSpec.getName(), 1, totalDocs, totalDocs);
            int[] dictIds = new int[]{0};
            for (int docId = 0; docId < totalDocs; ++docId) {
                mvFwdIndexCreator.index(docId, dictIds);
            }
            mvFwdIndexCreator.close();
        }
        SegmentColumnarIndexCreator.addColumnMetadataInfo(this._segmentProperties, column, columnIndexCreationInfo, totalDocs, totalRawDocs, totalAggDocs, fieldSpec, true, dictionaryElementSize, true, null);
    }

    protected static enum DefaultColumnAction {
        ADD_DIMENSION,
        ADD_METRIC,
        UPDATE_DIMENSION,
        UPDATE_METRIC,
        REMOVE_DIMENSION,
        REMOVE_METRIC;


        boolean isAddAction() {
            return this == ADD_DIMENSION || this == ADD_METRIC;
        }

        boolean isUpdateAction() {
            return this == UPDATE_DIMENSION || this == UPDATE_METRIC;
        }

        boolean isRemoveAction() {
            return this == REMOVE_DIMENSION || this == REMOVE_METRIC;
        }
    }
}

