/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.defaultcolumn;

import java.io.File;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.LoaderUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.V3RemoveIndexException;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.defaultcolumn.BaseDefaultColumnHandler;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.ColumnIndexType;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.SegmentDirectory;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V3DefaultColumnHandler
extends BaseDefaultColumnHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(V3DefaultColumnHandler.class);
    private final SegmentDirectory.Writer _segmentWriter;

    public V3DefaultColumnHandler(File indexDir, Schema schema, SegmentMetadataImpl segmentMetadata, SegmentDirectory.Writer segmentWriter) {
        super(indexDir, schema, segmentMetadata);
        this._segmentWriter = segmentWriter;
    }

    @Override
    protected void updateDefaultColumn(String column, BaseDefaultColumnHandler.DefaultColumnAction action) throws Exception {
        LOGGER.info("Starting default column action: {} on column: {}", (Object)action, (Object)column);
        if (!action.isAddAction()) {
            throw new V3RemoveIndexException("Default value indices for column: " + column + " cannot be removed for V3 format segment.");
        }
        this.createColumnV1Indices(column);
        FieldSpec fieldSpec = this._schema.getFieldSpecFor(column);
        Preconditions.checkNotNull(fieldSpec);
        boolean isSingleValue = fieldSpec.isSingleValueField();
        File dictionaryFile = new File(this._indexDir, column + ".dict");
        File forwardIndexFile = isSingleValue ? new File(this._indexDir, column + ".sv.sorted.fwd") : new File(this._indexDir, column + ".mv.fwd");
        LoaderUtils.writeIndexToV3Format(this._segmentWriter, column, dictionaryFile, ColumnIndexType.DICTIONARY);
        LoaderUtils.writeIndexToV3Format(this._segmentWriter, column, forwardIndexFile, ColumnIndexType.FORWARD_INDEX);
    }
}

