/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.invertedindex;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.commons.io.FileUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.DataFileReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.SingleColumnMultiValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.FixedBitMultiValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.FixedBitSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.inv.OffHeapBitmapInvertedIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.ColumnMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.LoaderUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.ColumnIndexType;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.SegmentDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvertedIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvertedIndexHandler.class);
    private final File _indexDir;
    private final SegmentDirectory.Writer _segmentWriter;
    private final String _segmentName;
    private final SegmentVersion _segmentVersion;
    private final Set<ColumnMetadata> _invertedIndexColumns = new HashSet<ColumnMetadata>();

    public InvertedIndexHandler(@Nonnull File indexDir, @Nonnull SegmentMetadataImpl segmentMetadata, @Nonnull IndexLoadingConfig indexLoadingConfig, @Nonnull SegmentDirectory.Writer segmentWriter) {
        this._indexDir = indexDir;
        this._segmentWriter = segmentWriter;
        this._segmentName = segmentMetadata.getName();
        this._segmentVersion = SegmentVersion.valueOf(segmentMetadata.getVersion());
        for (String column : indexLoadingConfig.getInvertedIndexColumns()) {
            ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
            if (columnMetadata == null || columnMetadata.isSorted()) continue;
            this._invertedIndexColumns.add(columnMetadata);
        }
    }

    public void createInvertedIndices() throws IOException {
        for (ColumnMetadata columnMetadata : this._invertedIndexColumns) {
            this.createInvertedIndexForColumn(columnMetadata);
        }
    }

    private void createInvertedIndexForColumn(ColumnMetadata columnMetadata) throws IOException {
        String column = columnMetadata.getColumnName();
        File inProgress = new File(this._indexDir, column + ".inv.inprogress");
        File invertedIndexFile = new File(this._indexDir, column + ".bitmap.inv");
        if (!inProgress.exists()) {
            if (this._segmentWriter.hasIndexFor(column, ColumnIndexType.INVERTED_INDEX)) {
                LOGGER.info("Found inverted index for segment: {}, column: {}", (Object)this._segmentName, (Object)column);
                return;
            }
            FileUtils.touch(inProgress);
        } else {
            FileUtils.deleteQuietly(invertedIndexFile);
        }
        LOGGER.info("Creating new inverted index for segment: {}, column: {}", (Object)this._segmentName, (Object)column);
        int numDocs = columnMetadata.getTotalDocs();
        try (OffHeapBitmapInvertedIndexCreator creator = new OffHeapBitmapInvertedIndexCreator(this._indexDir, columnMetadata.getFieldSpec(), columnMetadata.getCardinality(), numDocs, columnMetadata.getTotalNumberOfEntries());
             DataFileReader fwdIndex = this.getForwardIndexReader(columnMetadata, this._segmentWriter);){
            if (columnMetadata.isSingleValue()) {
                FixedBitSingleValueReader svFwdIndex = (FixedBitSingleValueReader)fwdIndex;
                for (int i = 0; i < numDocs; ++i) {
                    creator.add(svFwdIndex.getInt(i));
                }
            } else {
                SingleColumnMultiValueReader mvFwdIndex = (SingleColumnMultiValueReader)fwdIndex;
                int[] dictIds = new int[columnMetadata.getMaxNumberOfMultiValues()];
                for (int i = 0; i < numDocs; ++i) {
                    int length = mvFwdIndex.getIntArray(i, dictIds);
                    creator.add(dictIds, length);
                }
            }
            creator.seal();
        }
        if (this._segmentVersion == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(this._segmentWriter, column, invertedIndexFile, ColumnIndexType.INVERTED_INDEX);
        }
        FileUtils.deleteQuietly(inProgress);
        LOGGER.info("Created inverted index for segment: {}, column: {}", (Object)this._segmentName, (Object)column);
    }

    private DataFileReader getForwardIndexReader(ColumnMetadata columnMetadata, SegmentDirectory.Writer segmentWriter) throws IOException {
        PinotDataBuffer buffer = segmentWriter.getIndexFor(columnMetadata.getColumnName(), ColumnIndexType.FORWARD_INDEX);
        int numRows = columnMetadata.getTotalDocs();
        int numBitsPerValue = columnMetadata.getBitsPerElement();
        if (columnMetadata.isSingleValue()) {
            return new FixedBitSingleValueReader(buffer, numRows, numBitsPerValue);
        }
        return new FixedBitMultiValueReader(buffer, numRows, columnMetadata.getTotalNumberOfEntries(), numBitsPerValue);
    }
}

