/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapInvertedIndexReader
implements InvertedIndexReader<ImmutableRoaringBitmap> {
    public static final Logger LOGGER = LoggerFactory.getLogger(BitmapInvertedIndexReader.class);
    private final int numberOfBitmaps;
    private volatile SoftReference<SoftReference<ImmutableRoaringBitmap>[]> bitmaps = null;
    private PinotDataBuffer buffer;
    private File file = this.file;

    public BitmapInvertedIndexReader(PinotDataBuffer indexDataBuffer, int cardinality) throws IOException {
        this.numberOfBitmaps = cardinality;
        this.load(indexDataBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableRoaringBitmap getDocIds(int dictId) {
        ImmutableRoaringBitmap value;
        SoftReference[] bitmapArrayReference = null;
        if (this.bitmaps != null) {
            bitmapArrayReference = this.bitmaps.get();
            if (bitmapArrayReference != null) {
                SoftReference bitmapReference = bitmapArrayReference[dictId];
                if (bitmapReference != null && (value = (ImmutableRoaringBitmap)bitmapReference.get()) != null) {
                    return value;
                }
            } else {
                bitmapArrayReference = new SoftReference[this.numberOfBitmaps];
                this.bitmaps = new SoftReference<SoftReference[]>(bitmapArrayReference);
            }
        } else {
            bitmapArrayReference = new SoftReference[this.numberOfBitmaps];
            this.bitmaps = new SoftReference<SoftReference[]>(bitmapArrayReference);
        }
        BitmapInvertedIndexReader bitmapInvertedIndexReader = this;
        synchronized (bitmapInvertedIndexReader) {
            if (bitmapArrayReference[dictId] == null || bitmapArrayReference[dictId].get() == null) {
                value = this.buildRoaringBitmapForIndex(dictId);
                bitmapArrayReference[dictId] = new SoftReference<ImmutableRoaringBitmap>(value);
            } else {
                value = (ImmutableRoaringBitmap)bitmapArrayReference[dictId].get();
            }
            return value;
        }
    }

    private synchronized ImmutableRoaringBitmap buildRoaringBitmapForIndex(int index) {
        int currentOffset = this.getOffset(index);
        int nextOffset = this.getOffset(index + 1);
        int bufferLength = nextOffset - currentOffset;
        ByteBuffer bb = this.buffer.toDirectByteBuffer(currentOffset, bufferLength);
        ImmutableRoaringBitmap immutableRoaringBitmap = null;
        try {
            immutableRoaringBitmap = new ImmutableRoaringBitmap(bb);
        }
        catch (Exception e) {
            LOGGER.error("Error creating immutableRoaringBitmap for dictionary id:{} currentOffset:{} bufferLength:{} slice position{} limit:{} file:{}", new Object[]{index, currentOffset, bufferLength, bb.position(), bb.limit(), this.file.getAbsolutePath()});
        }
        return immutableRoaringBitmap;
    }

    private int getOffset(int index) {
        return this.buffer.getInt(index * 4);
    }

    private void load(PinotDataBuffer indexDataBuffer) throws IOException {
        int lastOffset = indexDataBuffer.getInt(this.numberOfBitmaps * 4);
        assert ((long)lastOffset == indexDataBuffer.size());
        this.buffer = indexDataBuffer;
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }
}

