/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers;

import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.ImmutableDictionaryReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class DoubleDictionary
extends ImmutableDictionaryReader {
    public DoubleDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 8, (byte)0);
    }

    @Override
    public int indexOf(Object rawValue) {
        int index = this.insertionIndexOf(rawValue);
        return index >= 0 ? index : -1;
    }

    @Override
    public int insertionIndexOf(Object rawValue) {
        double value = rawValue instanceof String ? Double.parseDouble((String)rawValue) : (Double)rawValue;
        return this.binarySearch(value);
    }

    @Override
    public Double get(int dictId) {
        return this.getDouble(dictId);
    }

    @Override
    public int getIntValue(int dictId) {
        return (int)this.getDouble(dictId);
    }

    @Override
    public long getLongValue(int dictId) {
        return (long)this.getDouble(dictId);
    }

    @Override
    public float getFloatValue(int dictId) {
        return (float)this.getDouble(dictId);
    }

    @Override
    public double getDoubleValue(int dictId) {
        return this.getDouble(dictId);
    }

    @Override
    public String getStringValue(int dictId) {
        return Double.toString(this.getDouble(dictId));
    }
}

