/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers;

import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.ImmutableDictionaryReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class FloatDictionary
extends ImmutableDictionaryReader {
    public FloatDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 4, (byte)0);
    }

    @Override
    public int indexOf(Object rawValue) {
        int index = this.insertionIndexOf(rawValue);
        return index >= 0 ? index : -1;
    }

    @Override
    public int insertionIndexOf(Object rawValue) {
        float value = rawValue instanceof String ? Float.parseFloat((String)rawValue) : ((Float)rawValue).floatValue();
        return this.binarySearch(value);
    }

    @Override
    public Float get(int dictId) {
        return Float.valueOf(this.getFloat(dictId));
    }

    @Override
    public int getIntValue(int dictId) {
        return (int)this.getFloat(dictId);
    }

    @Override
    public long getLongValue(int dictId) {
        return (long)this.getFloat(dictId);
    }

    @Override
    public float getFloatValue(int dictId) {
        return this.getFloat(dictId);
    }

    @Override
    public double getDoubleValue(int dictId) {
        return this.getFloat(dictId);
    }

    @Override
    public String getStringValue(int dictId) {
        return Float.toString(this.getFloat(dictId));
    }
}

