/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers;

import it.unimi.dsi.fastutil.doubles.Double2IntOpenHashMap;
import java.util.Arrays;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.OnHeapDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class OnHeapDoubleDictionary
extends OnHeapDictionary {
    private final Double2IntOpenHashMap _valToDictId;
    private final double[] _dictIdToVal;

    public OnHeapDoubleDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 8, (byte)0);
        this._valToDictId = new Double2IntOpenHashMap(length);
        this._valToDictId.defaultReturnValue(-1);
        this._dictIdToVal = new double[length];
        for (int dictId = 0; dictId < length; ++dictId) {
            double value;
            this._dictIdToVal[dictId] = value = this.getDouble(dictId);
            this._valToDictId.put(value, dictId);
        }
    }

    @Override
    public int indexOf(Object rawValue) {
        double value = this.getValue(rawValue);
        return this._valToDictId.get(value);
    }

    private double getValue(Object rawValue) {
        double value;
        if (rawValue instanceof String) {
            value = Double.parseDouble((String)rawValue);
        } else if (rawValue instanceof Double) {
            value = (Double)rawValue;
        } else {
            throw new IllegalArgumentException("Illegal data type for argument, actual: " + rawValue.getClass().getName() + " expected: " + Double.class.getName());
        }
        return value;
    }

    @Override
    public int insertionIndexOf(Object rawValue) {
        int index = this.indexOf(rawValue);
        return index != -1 ? index : Arrays.binarySearch(this._dictIdToVal, this.getValue(rawValue));
    }

    @Override
    public Double get(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public double getDoubleValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public String getStringValue(int dictId) {
        return Double.toString(this._dictIdToVal[dictId]);
    }
}

