/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers;

import it.unimi.dsi.fastutil.floats.Float2IntOpenHashMap;
import java.util.Arrays;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.OnHeapDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class OnHeapFloatDictionary
extends OnHeapDictionary {
    private final Float2IntOpenHashMap _valToDictId;
    private final float[] _dictIdToVal;

    public OnHeapFloatDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 4, (byte)0);
        this._valToDictId = new Float2IntOpenHashMap(length);
        this._valToDictId.defaultReturnValue(-1);
        this._dictIdToVal = new float[length];
        for (int dictId = 0; dictId < length; ++dictId) {
            float value;
            this._dictIdToVal[dictId] = value = this.getFloat(dictId);
            this._valToDictId.put(value, dictId);
        }
    }

    @Override
    public int indexOf(Object rawValue) {
        float value = this.getValue(rawValue);
        return this._valToDictId.get(value);
    }

    private float getValue(Object rawValue) {
        float value;
        if (rawValue instanceof String) {
            value = Float.parseFloat((String)rawValue);
        } else if (rawValue instanceof Float) {
            value = ((Float)rawValue).floatValue();
        } else {
            throw new IllegalArgumentException("Illegal data type for argument, actual: " + rawValue.getClass().getName() + " expected: " + Float.class.getName());
        }
        return value;
    }

    @Override
    public int insertionIndexOf(Object rawValue) {
        int index = this.indexOf(rawValue);
        return index != -1 ? index : Arrays.binarySearch(this._dictIdToVal, this.getValue(rawValue));
    }

    @Override
    public Float get(int dictId) {
        return Float.valueOf(this._dictIdToVal[dictId]);
    }

    @Override
    public float getFloatValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public double getDoubleValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public String getStringValue(int dictId) {
        return Float.toString(this._dictIdToVal[dictId]);
    }
}

