/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers;

import org.apache.pinot.$internal.org.apache.pinot.core.io.util.ValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.ImmutableDictionaryReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class StringDictionary
extends ImmutableDictionaryReader {
    public StringDictionary(PinotDataBuffer dataBuffer, int length, int numBytesPerValue, byte paddingByte) {
        super(dataBuffer, length, numBytesPerValue, paddingByte);
    }

    public StringDictionary(ValueReader valueReader, int length) {
        super(valueReader, length);
    }

    @Override
    public int indexOf(Object rawValue) {
        int index = this.insertionIndexOf(rawValue);
        return index >= 0 ? index : -1;
    }

    @Override
    public int insertionIndexOf(Object rawValue) {
        return this.binarySearch((String)rawValue);
    }

    @Override
    public String get(int dictId) {
        return this.getUnpaddedString(dictId, this.getBuffer());
    }

    @Override
    public String getStringValue(int dictId) {
        return this.getUnpaddedString(dictId, this.getBuffer());
    }

    @Override
    public void readStringValues(int[] dictIds, int inStartPos, int length, String[] outValues, int outStartPos) {
        byte[] buffer = this.getBuffer();
        int inEndPos = inStartPos + length;
        for (int i = inStartPos; i < inEndPos; ++i) {
            outValues[outStartPos++] = this.getUnpaddedString(dictIds[i], buffer);
        }
    }
}

