/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.store;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.ColumnIndexType;
import org.apache.pinot.common.segment.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ColumnIndexDirectory
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColumnIndexDirectory.class);
    protected File segmentDirectory;
    protected SegmentMetadataImpl metadata;
    protected ReadMode readMode;

    protected ColumnIndexDirectory(File segmentDirectory, SegmentMetadataImpl metadata, ReadMode readMode) {
        Preconditions.checkNotNull(segmentDirectory);
        Preconditions.checkNotNull(readMode);
        Preconditions.checkNotNull(metadata);
        Preconditions.checkArgument(segmentDirectory.exists(), "SegmentDirectory: " + segmentDirectory.toString() + " does not exist");
        Preconditions.checkArgument(segmentDirectory.isDirectory(), "SegmentDirectory: " + segmentDirectory.toString() + " is not a directory");
        this.segmentDirectory = segmentDirectory;
        this.metadata = metadata;
        this.readMode = readMode;
    }

    protected String allocationContext(File f, String context) {
        return this.getClass().getSimpleName() + "." + f.toString() + "." + context;
    }

    public abstract PinotDataBuffer getDictionaryBufferFor(String var1) throws IOException;

    public abstract PinotDataBuffer getForwardIndexBufferFor(String var1) throws IOException;

    public abstract PinotDataBuffer getInvertedIndexBufferFor(String var1) throws IOException;

    public abstract PinotDataBuffer getBloomFilterBufferFor(String var1) throws IOException;

    public abstract PinotDataBuffer newDictionaryBuffer(String var1, long var2) throws IOException;

    public abstract PinotDataBuffer newForwardIndexBuffer(String var1, long var2) throws IOException;

    public abstract PinotDataBuffer newInvertedIndexBuffer(String var1, long var2) throws IOException;

    public abstract PinotDataBuffer newBloomFilterBuffer(String var1, long var2) throws IOException;

    public abstract boolean hasIndexFor(String var1, ColumnIndexType var2);

    public abstract void removeIndex(String var1, ColumnIndexType var2);

    public abstract boolean isIndexRemovalSupported();

    protected File starTreeIndexFile() {
        return new File(this.segmentDirectory, "star-tree.bin");
    }
}

