/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.ColumnIndexDirectory;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.ColumnIndexType;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.IndexKey;
import org.apache.pinot.common.segment.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilePerIndexDirectory
extends ColumnIndexDirectory {
    private static Logger LOGGER = LoggerFactory.getLogger(FilePerIndexDirectory.class);
    private Map<IndexKey, PinotDataBuffer> indexBuffers = new HashMap<IndexKey, PinotDataBuffer>();

    protected FilePerIndexDirectory(File segmentDirectory, SegmentMetadataImpl metadata, ReadMode readMode) {
        super(segmentDirectory, metadata, readMode);
    }

    @Override
    public PinotDataBuffer getDictionaryBufferFor(String column) throws IOException {
        IndexKey key = new IndexKey(column, ColumnIndexType.DICTIONARY);
        return this.getReadBufferFor(key);
    }

    @Override
    public PinotDataBuffer newDictionaryBuffer(String column, long sizeBytes) throws IOException {
        IndexKey key = new IndexKey(column, ColumnIndexType.DICTIONARY);
        return this.getWriteBufferFor(key, sizeBytes);
    }

    @Override
    public PinotDataBuffer getForwardIndexBufferFor(String column) throws IOException {
        IndexKey key = new IndexKey(column, ColumnIndexType.FORWARD_INDEX);
        return this.getReadBufferFor(key);
    }

    @Override
    public PinotDataBuffer newForwardIndexBuffer(String column, long sizeBytes) throws IOException {
        IndexKey key = new IndexKey(column, ColumnIndexType.FORWARD_INDEX);
        return this.getWriteBufferFor(key, sizeBytes);
    }

    @Override
    public PinotDataBuffer getInvertedIndexBufferFor(String column) throws IOException {
        IndexKey key = new IndexKey(column, ColumnIndexType.INVERTED_INDEX);
        return this.getReadBufferFor(key);
    }

    @Override
    public PinotDataBuffer newInvertedIndexBuffer(String column, long sizeBytes) throws IOException {
        IndexKey key = new IndexKey(column, ColumnIndexType.INVERTED_INDEX);
        return this.getWriteBufferFor(key, sizeBytes);
    }

    @Override
    public PinotDataBuffer getBloomFilterBufferFor(String column) throws IOException {
        IndexKey key = new IndexKey(column, ColumnIndexType.BLOOM_FILTER);
        return this.getReadBufferFor(key);
    }

    @Override
    public PinotDataBuffer newBloomFilterBuffer(String column, long sizeBytes) throws IOException {
        IndexKey key = new IndexKey(column, ColumnIndexType.BLOOM_FILTER);
        return this.getWriteBufferFor(key, sizeBytes);
    }

    @Override
    public boolean hasIndexFor(String column, ColumnIndexType type) {
        File indexFile = this.getFileFor(column, type);
        return indexFile.exists();
    }

    @Override
    public void close() throws IOException {
        for (PinotDataBuffer dataBuffer : this.indexBuffers.values()) {
            dataBuffer.close();
        }
    }

    @Override
    public void removeIndex(String columnName, ColumnIndexType indexType) {
        File indexFile = this.getFileFor(columnName, indexType);
        indexFile.delete();
    }

    @Override
    public boolean isIndexRemovalSupported() {
        return true;
    }

    private PinotDataBuffer getReadBufferFor(IndexKey key) throws IOException {
        if (this.indexBuffers.containsKey(key)) {
            return this.indexBuffers.get(key);
        }
        File filename = this.getFileFor(key.name, key.type);
        PinotDataBuffer buffer = this.mapForReads(filename, key.type.toString() + ".reader");
        this.indexBuffers.put(key, buffer);
        return buffer;
    }

    private PinotDataBuffer getWriteBufferFor(IndexKey key, long sizeBytes) throws IOException {
        if (this.indexBuffers.containsKey(key)) {
            return this.indexBuffers.get(key);
        }
        File filename = this.getFileFor(key.name, key.type);
        PinotDataBuffer buffer = this.mapForWrites(filename, sizeBytes, key.type.toString() + ".writer");
        this.indexBuffers.put(key, buffer);
        return buffer;
    }

    @VisibleForTesting
    File getFileFor(String column, ColumnIndexType indexType) {
        String filename;
        switch (indexType) {
            case DICTIONARY: {
                filename = this.metadata.getDictionaryFileName(column);
                break;
            }
            case FORWARD_INDEX: {
                filename = this.metadata.getForwardIndexFileName(column);
                break;
            }
            case INVERTED_INDEX: {
                filename = this.metadata.getBitmapInvertedIndexFileName(column);
                break;
            }
            case BLOOM_FILTER: {
                filename = this.metadata.getBloomFilterFileName(column);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown index type: " + indexType.toString());
            }
        }
        return new File(this.segmentDirectory, filename);
    }

    private PinotDataBuffer mapForWrites(File file, long sizeBytes, String context) throws IOException {
        Preconditions.checkNotNull(file);
        Preconditions.checkArgument(sizeBytes >= 0L && sizeBytes < Integer.MAX_VALUE, "File size must be less than 2GB, file: " + file);
        Preconditions.checkState(!file.exists(), "File: " + file + " already exists");
        String allocationContext = this.allocationContext(file, context);
        return PinotDataBuffer.mapFile(file, false, 0L, sizeBytes, ByteOrder.BIG_ENDIAN, allocationContext);
    }

    private PinotDataBuffer mapForReads(File file, String context) throws IOException {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(context);
        Preconditions.checkArgument(file.exists(), "File: " + file + " must exist");
        Preconditions.checkArgument(file.isFile(), "File: " + file + " must be a regular file");
        String allocationContext = this.allocationContext(file, context);
        if (this.readMode == ReadMode.heap) {
            return PinotDataBuffer.loadFile(file, 0L, file.length(), ByteOrder.BIG_ENDIAN, allocationContext);
        }
        return PinotDataBuffer.mapFile(file, true, 0L, file.length(), ByteOrder.BIG_ENDIAN, allocationContext);
    }
}

