/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.configuration.ConfigurationException;
import org.apache.pinot.$internal.org.apache.commons.io.FileUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.ColumnIndexDirectory;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.ColumnIndexType;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.FilePerIndexDirectory;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.IndexKey;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.SegmentDirectory;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.SegmentDirectoryPaths;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.SingleFileIndexDirectory;
import org.apache.pinot.common.segment.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SegmentLocalFSDirectory
extends SegmentDirectory {
    private static Logger LOGGER = LoggerFactory.getLogger(SegmentLocalFSDirectory.class);
    private static final int PAGE_SIZE_BYTES = 4096;
    private static final long MAX_MMAP_PREFETCH_PAGES = 0x1900000L;
    private static final double PREFETCH_SLOWDOWN_PCT = 0.67;
    private static AtomicLong prefetchedPages = new AtomicLong(0L);
    private final File segmentDirectory;
    SegmentLock segmentLock;
    private SegmentMetadataImpl segmentMetadata;
    private ReadMode readMode;
    private ColumnIndexDirectory columnIndexDirectory;

    SegmentLocalFSDirectory(String directoryPath, SegmentMetadataImpl metadata, ReadMode readMode) {
        this(new File(directoryPath), metadata, readMode);
    }

    SegmentLocalFSDirectory(File directory, ReadMode readMode) throws IOException, ConfigurationException {
        this(directory, SegmentLocalFSDirectory.loadSegmentMetadata(directory), readMode);
    }

    SegmentLocalFSDirectory(File directoryFile, SegmentMetadataImpl metadata, ReadMode readMode) {
        Preconditions.checkNotNull(directoryFile);
        Preconditions.checkNotNull(metadata);
        this.segmentDirectory = this.getSegmentPath(directoryFile, metadata.getSegmentVersion());
        Preconditions.checkState(this.segmentDirectory.exists(), "Segment directory: " + directoryFile + " must exist");
        this.segmentLock = new SegmentLock();
        this.segmentMetadata = metadata;
        this.readMode = readMode;
        try {
            this.load();
        }
        catch (IOException | ConfigurationException e) {
            LOGGER.error("Failed to load segment, error: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private File getSegmentPath(File segmentDirectory, SegmentVersion segmentVersion) {
        if (segmentVersion == SegmentVersion.v1 || segmentVersion == SegmentVersion.v2) {
            return segmentDirectory;
        }
        if (segmentVersion == SegmentVersion.v3) {
            if (segmentDirectory.getAbsolutePath().endsWith("v3")) {
                return segmentDirectory;
            }
            File v3SubDir = new File(segmentDirectory, "v3");
            if (v3SubDir.exists()) {
                return v3SubDir;
            }
            return segmentDirectory;
        }
        throw new IllegalArgumentException("Unknown segment version: " + (Object)((Object)segmentVersion));
    }

    public static SegmentMetadataImpl loadSegmentMetadata(File segmentDirectory) throws IOException, ConfigurationException {
        return new SegmentMetadataImpl(segmentDirectory);
    }

    @Override
    public Path getPath() {
        return this.segmentDirectory.toPath();
    }

    @Override
    public long getDiskSizeBytes() {
        if (this.segmentDirectory.exists()) {
            try {
                return FileUtils.sizeOfDirectory(this.segmentDirectory.toPath().toFile());
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Failed to read disk size for direcotry: ", (Object)this.segmentDirectory.getAbsolutePath());
                return -1L;
            }
        }
        if (!SegmentDirectoryPaths.isV3Directory(this.segmentDirectory)) {
            LOGGER.error("Segment directory: {} not found on disk and is not v3 format", (Object)this.segmentDirectory.getAbsolutePath());
            return -1L;
        }
        File[] files = this.segmentDirectory.getParentFile().listFiles();
        if (files == null) {
            LOGGER.warn("Empty list of files for path: {}, segmentDirectory: {}", (Object)this.segmentDirectory.getParentFile(), (Object)this.segmentDirectory);
            return -1L;
        }
        long size = 0L;
        for (File file : files) {
            if (!file.isFile()) continue;
            size += file.length();
        }
        return size;
    }

    @Override
    public Reader createReader() throws IOException {
        if (this.segmentLock.tryReadLock()) {
            this.loadData();
            return new Reader();
        }
        return null;
    }

    @Override
    public Writer createWriter() throws IOException {
        if (this.segmentLock.tryWriteLock()) {
            this.loadData();
            return new Writer();
        }
        return null;
    }

    @Override
    public String toString() {
        return this.segmentDirectory.toString();
    }

    protected void load() throws IOException, ConfigurationException {
        this.loadData();
    }

    private synchronized void loadData() throws IOException {
        if (this.columnIndexDirectory != null) {
            return;
        }
        String version = this.segmentMetadata.getVersion();
        SegmentVersion segmentVersion = SegmentVersion.valueOf(version);
        switch (segmentVersion) {
            case v1: 
            case v2: {
                this.columnIndexDirectory = new FilePerIndexDirectory(this.segmentDirectory, this.segmentMetadata, this.readMode);
                break;
            }
            case v3: {
                try {
                    this.columnIndexDirectory = new SingleFileIndexDirectory(this.segmentDirectory, this.segmentMetadata, this.readMode);
                    break;
                }
                catch (ConfigurationException e) {
                    LOGGER.error("Failed to create columnar index directory", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.segmentLock.close();
        SegmentLocalFSDirectory segmentLocalFSDirectory = this;
        synchronized (segmentLocalFSDirectory) {
            if (this.columnIndexDirectory != null) {
                this.columnIndexDirectory.close();
                this.columnIndexDirectory = null;
            }
        }
    }

    protected File starTreeIndexFile() {
        return new File(this.segmentDirectory, "star-tree.bin");
    }

    private PinotDataBuffer getIndexForColumn(String column, ColumnIndexType type) throws IOException {
        PinotDataBuffer buffer;
        switch (type) {
            case DICTIONARY: {
                buffer = this.columnIndexDirectory.getDictionaryBufferFor(column);
                break;
            }
            case FORWARD_INDEX: {
                buffer = this.columnIndexDirectory.getForwardIndexBufferFor(column);
                break;
            }
            case INVERTED_INDEX: {
                buffer = this.columnIndexDirectory.getInvertedIndexBufferFor(column);
                break;
            }
            case BLOOM_FILTER: {
                buffer = this.columnIndexDirectory.getBloomFilterBufferFor(column);
                break;
            }
            default: {
                throw new RuntimeException("Unknown index type: " + type.name());
            }
        }
        if (this.readMode == ReadMode.mmap) {
            this.prefetchMmapData(buffer);
        }
        return buffer;
    }

    private void prefetchMmapData(PinotDataBuffer buffer) {
        if (prefetchedPages.get() >= 0x1900000L) {
            return;
        }
        long prefetchSlowdownPageLimit = 0x10C0000L;
        if (prefetchedPages.get() >= 0x10C0000L) {
            if (0L < buffer.size()) {
                buffer.getByte(0);
                prefetchedPages.incrementAndGet();
            }
        } else {
            for (long pos = 0L; pos < buffer.size() && prefetchedPages.get() < 0x10C0000L; pos += 4096L) {
                buffer.getByte((int)pos);
                prefetchedPages.incrementAndGet();
            }
        }
    }

    private boolean hasIndexFor(String column, ColumnIndexType type) {
        return this.columnIndexDirectory.hasIndexFor(column, type);
    }

    private InputStream getStarTreeStream() {
        File starTreeFile = this.starTreeIndexFile();
        Preconditions.checkState(starTreeFile.exists(), "Star tree file for segment: {} does not exist");
        Preconditions.checkState(starTreeFile.isFile(), "Star tree file: {} for segment: {} is not a regular file");
        try {
            return new FileInputStream(starTreeFile);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Star tree file for segment: {} is not found", (Object)this.segmentDirectory, (Object)e);
            throw new IllegalStateException("Star tree file for segment: " + this.segmentDirectory + " is not found", e);
        }
    }

    public boolean hasStarTree() {
        return this.starTreeIndexFile().exists();
    }

    class SegmentLock
    implements AutoCloseable {
        int readers = 0;
        int writers = 0;

        SegmentLock() {
        }

        synchronized boolean tryReadLock() {
            if (this.writers > 0) {
                return false;
            }
            ++this.readers;
            return true;
        }

        synchronized boolean tryWriteLock() {
            if (this.readers > 0 || this.writers > 0) {
                return false;
            }
            ++this.writers;
            return true;
        }

        synchronized void unlock() {
            if (this.writers > 0) {
                --this.writers;
            } else if (this.readers > 0) {
                --this.readers;
            }
        }

        @Override
        public void close() {
            this.unlock();
        }
    }

    public class Writer
    extends SegmentDirectory.Writer {
        public Writer() {
            super(SegmentLocalFSDirectory.this);
        }

        @Override
        public PinotDataBuffer newIndexFor(String columnName, ColumnIndexType indexType, long sizeBytes) throws IOException {
            return this.getNewIndexBuffer(new IndexKey(columnName, indexType), sizeBytes);
        }

        @Override
        public OutputStream starTreeOutputStream() {
            try {
                return new FileOutputStream(SegmentLocalFSDirectory.this.starTreeIndexFile());
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Failed to open star tree output stream for segment: {}", (Object)SegmentLocalFSDirectory.this.segmentDirectory, (Object)e);
                throw new RuntimeException("Failed to open star tree output stream for segment: " + SegmentLocalFSDirectory.this.segmentDirectory, e);
            }
        }

        @Override
        public boolean isIndexRemovalSupported() {
            return SegmentLocalFSDirectory.this.columnIndexDirectory.isIndexRemovalSupported();
        }

        @Override
        public InputStream getStarTreeStream() {
            return SegmentLocalFSDirectory.this.getStarTreeStream();
        }

        @Override
        public File getStarTreeFile() {
            return SegmentLocalFSDirectory.this.starTreeIndexFile();
        }

        @Override
        public boolean hasStarTree() {
            return SegmentLocalFSDirectory.this.hasStarTree();
        }

        @Override
        public void removeIndex(String columnName, ColumnIndexType indexType) {
            SegmentLocalFSDirectory.this.columnIndexDirectory.removeIndex(columnName, indexType);
        }

        @Override
        public void removeStarTree() {
            SegmentLocalFSDirectory.this.starTreeIndexFile().delete();
        }

        private PinotDataBuffer getNewIndexBuffer(IndexKey key, long sizeBytes) throws IOException {
            ColumnIndexType indexType = key.type;
            switch (indexType) {
                case DICTIONARY: {
                    return SegmentLocalFSDirectory.this.columnIndexDirectory.newDictionaryBuffer(key.name, sizeBytes);
                }
                case FORWARD_INDEX: {
                    return SegmentLocalFSDirectory.this.columnIndexDirectory.newForwardIndexBuffer(key.name, sizeBytes);
                }
                case INVERTED_INDEX: {
                    return SegmentLocalFSDirectory.this.columnIndexDirectory.newInvertedIndexBuffer(key.name, sizeBytes);
                }
                case BLOOM_FILTER: {
                    return SegmentLocalFSDirectory.this.columnIndexDirectory.newBloomFilterBuffer(key.name, sizeBytes);
                }
            }
            throw new RuntimeException("Unknown index type: " + indexType.name() + " for directory: " + SegmentLocalFSDirectory.this.segmentDirectory);
        }

        @Override
        public void abortAndClose() throws Exception {
            this.abort();
            this.close();
        }

        @Override
        public void save() throws IOException {
        }

        @Override
        void abort() {
        }

        @Override
        public String toString() {
            return SegmentLocalFSDirectory.this.segmentDirectory.toString();
        }

        @Override
        public void close() throws IOException {
            SegmentLocalFSDirectory.this.segmentLock.unlock();
            if (SegmentLocalFSDirectory.this.columnIndexDirectory != null) {
                SegmentLocalFSDirectory.this.columnIndexDirectory.close();
            }
            SegmentLocalFSDirectory.this.columnIndexDirectory = null;
        }

        @Override
        public PinotDataBuffer getIndexFor(String column, ColumnIndexType type) throws IOException {
            return SegmentLocalFSDirectory.this.getIndexForColumn(column, type);
        }

        @Override
        public boolean hasIndexFor(String column, ColumnIndexType type) {
            return SegmentLocalFSDirectory.this.columnIndexDirectory.hasIndexFor(column, type);
        }
    }

    public class Reader
    extends SegmentDirectory.Reader {
        public Reader() {
            super(SegmentLocalFSDirectory.this);
        }

        @Override
        public PinotDataBuffer getIndexFor(String column, ColumnIndexType type) throws IOException {
            return SegmentLocalFSDirectory.this.getIndexForColumn(column, type);
        }

        @Override
        public InputStream getStarTreeStream() {
            return SegmentLocalFSDirectory.this.getStarTreeStream();
        }

        @Override
        public File getStarTreeFile() {
            return SegmentLocalFSDirectory.this.starTreeIndexFile();
        }

        @Override
        public boolean hasStarTree() {
            return SegmentLocalFSDirectory.this.hasStarTree();
        }

        @Override
        public boolean hasIndexFor(String column, ColumnIndexType type) {
            return SegmentLocalFSDirectory.this.columnIndexDirectory.hasIndexFor(column, type);
        }

        @Override
        public void close() {
            SegmentLocalFSDirectory.this.segmentLock.unlock();
        }

        @Override
        public String toString() {
            return SegmentLocalFSDirectory.this.segmentDirectory.toString();
        }
    }
}

