/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree;

import java.nio.ByteBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class DimensionBuffer {
    private final ByteBuffer _buffer;

    public static DimensionBuffer fromBytes(byte[] bytes) {
        return new DimensionBuffer(bytes);
    }

    public DimensionBuffer(int numDimensions) {
        this._buffer = ByteBuffer.wrap(new byte[numDimensions * 4]).order(PinotDataBuffer.NATIVE_ORDER);
    }

    private DimensionBuffer(byte[] bytes) {
        this._buffer = ByteBuffer.wrap(bytes).order(PinotDataBuffer.NATIVE_ORDER);
    }

    public int getDictId(int index) {
        return this._buffer.getInt(index * 4);
    }

    public void setDictId(int index, int dictId) {
        this._buffer.putInt(index * 4, dictId);
    }

    public byte[] toBytes() {
        return this._buffer.array();
    }

    public boolean hasSameBytes(byte[] dimensionBytes) {
        byte[] bytes = this._buffer.array();
        int numBytes = bytes.length;
        for (int i = 0; i < numBytes; ++i) {
            if (bytes[i] == dimensionBytes[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        String delimiter = "";
        int numBytes = this._buffer.limit();
        for (int i = 0; i < numBytes; i += 4) {
            builder.append(delimiter).append(this._buffer.getInt(i));
            delimiter = ", ";
        }
        builder.append("]");
        return builder.toString();
    }
}

