/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.hll.HllUtil;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.MetricFieldSpec;

public class MetricBuffer {
    private final Object[] _values;
    private final List<MetricFieldSpec> _metricFieldSpecs;

    public static MetricBuffer fromBytes(byte[] bytes, List<MetricFieldSpec> metricFieldSpecs) {
        int numMetrics = metricFieldSpecs.size();
        Object[] values = new Object[numMetrics];
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(PinotDataBuffer.NATIVE_ORDER);
        block7: for (int i = 0; i < numMetrics; ++i) {
            MetricFieldSpec metricFieldSpec = metricFieldSpecs.get(i);
            switch (metricFieldSpec.getDataType()) {
                case INT: {
                    values[i] = buffer.getInt();
                    continue block7;
                }
                case LONG: {
                    values[i] = buffer.getLong();
                    continue block7;
                }
                case FLOAT: {
                    values[i] = Float.valueOf(buffer.getFloat());
                    continue block7;
                }
                case DOUBLE: {
                    values[i] = buffer.getDouble();
                    continue block7;
                }
                case STRING: {
                    assert (metricFieldSpec.getDerivedMetricType() == MetricFieldSpec.DerivedMetricType.HLL);
                    byte[] hllBytes = new byte[metricFieldSpec.getFieldSize()];
                    buffer.get(hllBytes);
                    values[i] = HllUtil.buildHllFromBytes(hllBytes);
                    continue block7;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return new MetricBuffer(values, metricFieldSpecs);
    }

    public MetricBuffer(Object[] values, List<MetricFieldSpec> metricFieldSpecs) {
        this._values = values;
        this._metricFieldSpecs = metricFieldSpecs;
    }

    public byte[] toBytes(int byteSize) {
        byte[] bytes = new byte[byteSize];
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(PinotDataBuffer.NATIVE_ORDER);
        int numValues = this._values.length;
        block7: for (int i = 0; i < numValues; ++i) {
            MetricFieldSpec metricFieldSpec = this._metricFieldSpecs.get(i);
            switch (metricFieldSpec.getDataType()) {
                case INT: {
                    buffer.putInt((Integer)this._values[i]);
                    continue block7;
                }
                case LONG: {
                    buffer.putLong((Long)this._values[i]);
                    continue block7;
                }
                case FLOAT: {
                    buffer.putFloat(((Float)this._values[i]).floatValue());
                    continue block7;
                }
                case DOUBLE: {
                    buffer.putDouble((Double)this._values[i]);
                    continue block7;
                }
                case STRING: {
                    assert (metricFieldSpec.getDerivedMetricType() == MetricFieldSpec.DerivedMetricType.HLL);
                    buffer.put(HllUtil.toBytes((HyperLogLog)this._values[i]));
                    continue block7;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return bytes;
    }

    public void aggregate(MetricBuffer buffer) {
        int numValues = this._values.length;
        block9: for (int i = 0; i < numValues; ++i) {
            MetricFieldSpec metricFieldSpec = this._metricFieldSpecs.get(i);
            switch (metricFieldSpec.getDataType()) {
                case INT: {
                    this._values[i] = (Integer)this._values[i] + (Integer)buffer._values[i];
                    continue block9;
                }
                case LONG: {
                    this._values[i] = (Long)this._values[i] + (Long)buffer._values[i];
                    continue block9;
                }
                case FLOAT: {
                    this._values[i] = Float.valueOf(((Float)this._values[i]).floatValue() + ((Float)buffer._values[i]).floatValue());
                    continue block9;
                }
                case DOUBLE: {
                    this._values[i] = (Double)this._values[i] + (Double)buffer._values[i];
                    continue block9;
                }
                case STRING: {
                    assert (metricFieldSpec.getDerivedMetricType() == MetricFieldSpec.DerivedMetricType.HLL);
                    try {
                        ((HyperLogLog)this._values[i]).addAll((HyperLogLog)buffer._values[i]);
                        continue block9;
                    }
                    catch (CardinalityMergeException e) {
                        throw new RuntimeException(e);
                    }
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public Object getValueConformToDataType(int index) {
        MetricFieldSpec metricFieldSpec = this._metricFieldSpecs.get(index);
        if (metricFieldSpec.getDataType() == FieldSpec.DataType.STRING) {
            assert (metricFieldSpec.getDerivedMetricType() == MetricFieldSpec.DerivedMetricType.HLL);
            return HllUtil.convertHllToString((HyperLogLog)this._values[index]);
        }
        return this._values[index];
    }
}

