/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.$internal.com.google.common.collect.BiMap;
import org.apache.pinot.$internal.com.google.common.collect.HashBiMap;
import org.apache.pinot.$internal.org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.pinot.$internal.org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.ColumnIndexCreationInfo;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.DimensionBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.MetricBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.StarTreeBuilder;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.StarTreeBuilderConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.StarTreeBuilderUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.StarTreeDataTable;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.hll.HllUtil;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.MetricFieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.utils.FileUtils;
import org.apache.pinot.common.utils.Pairs;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffHeapStarTreeBuilder
implements StarTreeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffHeapStarTreeBuilder.class);
    private static final long MMAP_SIZE_THRESHOLD = 500000000L;
    private File _tempDir;
    private File _dataFile;
    private BufferedOutputStream _outputStream;
    private Schema _schema;
    private List<MetricFieldSpec> _metricFieldSpecs;
    private List<Integer> _dimensionsSplitOrder;
    private Set<Integer> _skipStarNodeCreationDimensions;
    private Set<Integer> _skipMaterializationDimensions;
    private int _skipMaterializationCardinalityThreshold;
    private int _maxNumLeafRecords;
    private boolean _excludeSkipMaterializationDimensionsForStarTreeIndex;
    private int _numRawDocs;
    private int _numAggregatedDocs;
    private StarTreeBuilderUtils.TreeNode _rootNode;
    private int _numNodes;
    private int _numDimensions;
    private final List<String> _dimensionNames = new ArrayList<String>();
    private final List<Object> _dimensionStarValues = new ArrayList<Object>();
    private final List<BiMap<Object, Integer>> _dimensionDictionaries = new ArrayList<BiMap<Object, Integer>>();
    private int _dimensionSize;
    private int _numMetrics;
    private final List<String> _metricNames = new ArrayList<String>();
    private int _metricSize;
    private long _docSizeLong;
    private int[] _sortOrder;
    private final Set<StarTreeDataTable> _dataTablesToClose = new HashSet<StarTreeDataTable>();

    @Override
    public void init(StarTreeBuilderConfig builderConfig) throws IOException {
        Set<String> skipMaterializationDimensions;
        Set<String> set;
        this._tempDir = builderConfig.getOutDir();
        if (this._tempDir == null) {
            this._tempDir = new File(org.apache.pinot.$internal.org.apache.commons.io.FileUtils.getTempDirectory(), "star-tree_" + DateTime.now());
        }
        org.apache.pinot.$internal.org.apache.commons.io.FileUtils.forceMkdir(this._tempDir);
        LOGGER.info("Star tree temporary directory: {}", (Object)this._tempDir);
        this._dataFile = new File(this._tempDir, "star-tree.buf");
        LOGGER.info("Star tree data file: {}", (Object)this._dataFile);
        this._outputStream = new BufferedOutputStream(new FileOutputStream(this._dataFile));
        this._schema = builderConfig.getSchema();
        this._metricFieldSpecs = this._schema.getMetricFieldSpecs();
        this._skipMaterializationCardinalityThreshold = builderConfig.getSkipMaterializationCardinalityThreshold();
        this._maxNumLeafRecords = builderConfig.getMaxNumLeafRecords();
        this._excludeSkipMaterializationDimensionsForStarTreeIndex = builderConfig.isExcludeSkipMaterializationDimensionsForStarTreeIndex();
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            if (fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) continue;
            String dimensionName = fieldSpec.getName();
            ++this._numDimensions;
            this._dimensionNames.add(dimensionName);
            this._dimensionStarValues.add(fieldSpec.getDefaultNullValue());
            this._dimensionDictionaries.add(HashBiMap.create());
        }
        this._dimensionSize = this._numDimensions * 4;
        List<String> dimensionsSplitOrder = builderConfig.getDimensionsSplitOrder();
        if (dimensionsSplitOrder != null) {
            this._dimensionsSplitOrder = new ArrayList<Integer>(dimensionsSplitOrder.size());
            for (String dimensionName : dimensionsSplitOrder) {
                this._dimensionsSplitOrder.add(this._dimensionNames.indexOf(dimensionName));
            }
        }
        if ((set = builderConfig.getSkipStarNodeCreationDimensions()) != null) {
            this._skipStarNodeCreationDimensions = this.getDimensionIdSet(set);
        }
        if ((skipMaterializationDimensions = builderConfig.getSkipMaterializationDimensions()) != null) {
            this._skipMaterializationDimensions = this.getDimensionIdSet(skipMaterializationDimensions);
        }
        for (MetricFieldSpec metricFieldSpec : this._metricFieldSpecs) {
            ++this._numMetrics;
            this._metricNames.add(metricFieldSpec.getName());
            this._metricSize += metricFieldSpec.getFieldSize();
        }
        LOGGER.info("Dimension Names: {}", this._dimensionNames);
        LOGGER.info("Metric Names: {}", this._metricNames);
        this._docSizeLong = this._dimensionSize + this._metricSize;
        this._rootNode = new StarTreeBuilderUtils.TreeNode();
        ++this._numNodes;
    }

    private Set<Integer> getDimensionIdSet(Set<String> dimensionNameSet) {
        HashSet<Integer> dimensionIdSet = new HashSet<Integer>(dimensionNameSet.size());
        for (int i = 0; i < this._numDimensions; ++i) {
            if (!dimensionNameSet.contains(this._dimensionNames.get(i))) continue;
            dimensionIdSet.add(i);
        }
        return dimensionIdSet;
    }

    @Override
    public void append(GenericRow row) throws IOException {
        DimensionBuffer dimensions = new DimensionBuffer(this._numDimensions);
        for (int i = 0; i < this._numDimensions; ++i) {
            String dimensionName = this._dimensionNames.get(i);
            Object dimensionValue = row.getValue(dimensionName);
            BiMap<Object, Integer> dimensionDictionary = this._dimensionDictionaries.get(i);
            Integer dictId = (Integer)dimensionDictionary.get(dimensionValue);
            if (dictId == null) {
                dictId = dimensionDictionary.size();
                dimensionDictionary.put(dimensionValue, dictId);
            }
            dimensions.setDictId(i, dictId);
        }
        Object[] metricValues = new Object[this._numMetrics];
        for (int i = 0; i < this._numMetrics; ++i) {
            String metricName = this._metricNames.get(i);
            Object metricValue = row.getValue(metricName);
            metricValues[i] = this._metricFieldSpecs.get(i).getDerivedMetricType() == MetricFieldSpec.DerivedMetricType.HLL ? HllUtil.convertStringToHll((String)metricValue) : metricValue;
        }
        MetricBuffer metrics = new MetricBuffer(metricValues, this._metricFieldSpecs);
        this.appendToRawBuffer(dimensions, metrics);
    }

    private void appendToRawBuffer(DimensionBuffer dimensions, MetricBuffer metrics) throws IOException {
        this.appendToBuffer(dimensions, metrics);
        ++this._numRawDocs;
    }

    private void appendToAggBuffer(DimensionBuffer dimensions, MetricBuffer metrics) throws IOException {
        this.appendToBuffer(dimensions, metrics);
        ++this._numAggregatedDocs;
    }

    private void appendToBuffer(DimensionBuffer dimensions, MetricBuffer metrics) throws IOException {
        this._outputStream.write(dimensions.toBytes(), 0, this._dimensionSize);
        this._outputStream.write(metrics.toBytes(this._metricSize), 0, this._metricSize);
    }

    @Override
    public void build() throws IOException {
        this._outputStream.flush();
        if (this._skipMaterializationDimensions == null) {
            this._skipMaterializationDimensions = this.computeDefaultDimensionsToSkipMaterialization();
        }
        if (this._dimensionsSplitOrder == null || this._dimensionsSplitOrder.isEmpty()) {
            this._dimensionsSplitOrder = this.computeDefaultSplitOrder();
        } else {
            this._skipMaterializationDimensions.removeAll(this._dimensionsSplitOrder);
        }
        LOGGER.info("Split Order: {}", this._dimensionsSplitOrder);
        LOGGER.info("Skip Materialization Dimensions: {}", this._skipMaterializationDimensions);
        ArrayList<Integer> sortOrderList = new ArrayList<Integer>(this._dimensionsSplitOrder);
        for (int i = 0; i < this._numDimensions; ++i) {
            if (this._dimensionsSplitOrder.contains(i) || this._skipMaterializationDimensions.contains(i)) continue;
            sortOrderList.add(i);
        }
        int numDimensionsInSortOrder = sortOrderList.size();
        this._sortOrder = new int[numDimensionsInSortOrder];
        for (int i = 0; i < numDimensionsInSortOrder; ++i) {
            this._sortOrder[i] = (Integer)sortOrderList.get(i);
        }
        long start = System.currentTimeMillis();
        if (!this._skipMaterializationDimensions.isEmpty() && this._excludeSkipMaterializationDimensionsForStarTreeIndex) {
            this.removeSkipMaterializationDimensions();
            this.constructStarTree(this._rootNode, this._numRawDocs, this._numRawDocs + this._numAggregatedDocs, 0);
        } else {
            try (StarTreeDataTable dataTable = new StarTreeDataTable(PinotDataBuffer.mapFile(this._dataFile, false, 0L, this._dataFile.length(), PinotDataBuffer.NATIVE_ORDER, "OffHeapStarTreeBuilder#build: data buffer"), this._dimensionSize, this._metricSize, 0);){
                dataTable.sort(0, this._numRawDocs, this._sortOrder);
            }
            this.constructStarTree(this._rootNode, 0, this._numRawDocs, 0);
        }
        this.splitLeafNodesOnTimeColumn();
        this.createAggregatedDocForAllNodes();
        long end = System.currentTimeMillis();
        LOGGER.info("Took {}ms to build star tree index with {} raw documents and {} aggregated documents", new Object[]{end - start, this._numRawDocs, this._numAggregatedDocs});
    }

    private void removeSkipMaterializationDimensions() throws IOException {
        try (StarTreeDataTable dataTable = new StarTreeDataTable(PinotDataBuffer.mapFile(this._dataFile, false, 0L, this._dataFile.length(), PinotDataBuffer.NATIVE_ORDER, "OffHeapStarTreeBuilder#removeSkipMaterializationDimensions: data buffer"), this._dimensionSize, this._metricSize, 0);){
            dataTable.sort(0, this._numRawDocs, this._sortOrder);
            Iterator<Pair<byte[], byte[]>> iterator = dataTable.iterator(0, this._numRawDocs);
            DimensionBuffer currentDimensions = null;
            MetricBuffer currentMetrics = null;
            while (iterator.hasNext()) {
                Pair<byte[], byte[]> next = iterator.next();
                byte[] dimensionBytes = next.getLeft();
                DimensionBuffer dimensions = DimensionBuffer.fromBytes(dimensionBytes);
                MetricBuffer metrics = MetricBuffer.fromBytes(next.getRight(), this._metricFieldSpecs);
                for (int i = 0; i < this._numDimensions; ++i) {
                    if (!this._skipMaterializationDimensions.contains(i)) continue;
                    dimensions.setDictId(i, -1);
                }
                if (currentDimensions == null) {
                    currentDimensions = dimensions;
                    currentMetrics = metrics;
                    continue;
                }
                if (currentDimensions.hasSameBytes(dimensionBytes)) {
                    currentMetrics.aggregate(metrics);
                    continue;
                }
                this.appendToAggBuffer(currentDimensions, currentMetrics);
                currentDimensions = dimensions;
                currentMetrics = metrics;
            }
            this.appendToAggBuffer(currentDimensions, currentMetrics);
        }
        this._outputStream.flush();
    }

    private void createAggregatedDocForAllNodes() throws IOException {
        try (StarTreeDataTable dataTable = new StarTreeDataTable(PinotDataBuffer.mapFile(this._dataFile, true, 0L, this._dataFile.length(), PinotDataBuffer.NATIVE_ORDER, "OffHeapStarTreeBuilder#createAggregatedDocForAllNodes: data buffer"), this._dimensionSize, this._metricSize, 0);){
            DimensionBuffer dimensions = new DimensionBuffer(this._numDimensions);
            for (int i = 0; i < this._numDimensions; ++i) {
                dimensions.setDictId(i, -1);
            }
            this.createAggregatedDocForAllNodesHelper(dataTable, this._rootNode, dimensions);
        }
        this._outputStream.flush();
    }

    private MetricBuffer createAggregatedDocForAllNodesHelper(StarTreeDataTable dataTable, StarTreeBuilderUtils.TreeNode node, DimensionBuffer dimensions) throws IOException {
        MetricBuffer aggregatedMetrics = null;
        if (node._children == null) {
            Iterator<Pair<byte[], byte[]>> iterator = dataTable.iterator(node._startDocId, node._endDocId);
            Pair<byte[], byte[]> first = iterator.next();
            aggregatedMetrics = MetricBuffer.fromBytes(first.getRight(), this._metricFieldSpecs);
            while (iterator.hasNext()) {
                Pair<byte[], byte[]> next = iterator.next();
                MetricBuffer metricBuffer = MetricBuffer.fromBytes(next.getRight(), this._metricFieldSpecs);
                aggregatedMetrics.aggregate(metricBuffer);
            }
        } else {
            int childDimensionId = node._childDimensionId;
            for (Map.Entry<Integer, StarTreeBuilderUtils.TreeNode> entry : node._children.entrySet()) {
                int childDimensionValue = entry.getKey();
                StarTreeBuilderUtils.TreeNode child = entry.getValue();
                dimensions.setDictId(childDimensionId, childDimensionValue);
                MetricBuffer childAggregatedMetrics = this.createAggregatedDocForAllNodesHelper(dataTable, child, dimensions);
                if (childDimensionValue == -1) continue;
                if (aggregatedMetrics == null) {
                    aggregatedMetrics = childAggregatedMetrics;
                    continue;
                }
                aggregatedMetrics.aggregate(childAggregatedMetrics);
            }
            dimensions.setDictId(childDimensionId, -1);
        }
        node._aggregatedDocId = this._numRawDocs + this._numAggregatedDocs;
        this.appendToAggBuffer(dimensions, aggregatedMetrics);
        return aggregatedMetrics;
    }

    private void splitLeafNodesOnTimeColumn() throws IOException {
        int timeColumnId;
        String timeColumnName = this._schema.getTimeColumnName();
        if (timeColumnName != null && !this._skipMaterializationDimensions.contains(timeColumnId = this._dimensionNames.indexOf(timeColumnName)) && !this._dimensionsSplitOrder.contains(timeColumnId)) {
            try (StarTreeDataTable dataTable = new StarTreeDataTable(PinotDataBuffer.mapFile(this._dataFile, false, 0L, this._dataFile.length(), PinotDataBuffer.NATIVE_ORDER, "OffHeapStarTreeBuilder#splitLeafNodesOnTimeColumn: data buffer"), this._dimensionSize, this._metricSize, 0);){
                this.splitLeafNodesOnTimeColumnHelper(dataTable, this._rootNode, 0, timeColumnId);
            }
        }
    }

    private void splitLeafNodesOnTimeColumnHelper(StarTreeDataTable dataTable, StarTreeBuilderUtils.TreeNode node, int level, int timeColumnId) {
        if (node._children == null) {
            int startDocId = node._startDocId;
            int endDocId = node._endDocId;
            dataTable.sort(startDocId, endDocId, this.getNewSortOrder(timeColumnId, level));
            Int2ObjectMap<Pairs.IntPair> timeColumnRangeMap = dataTable.groupOnDimension(startDocId, endDocId, timeColumnId);
            node._childDimensionId = timeColumnId;
            HashMap<Integer, StarTreeBuilderUtils.TreeNode> children = new HashMap<Integer, StarTreeBuilderUtils.TreeNode>(timeColumnRangeMap.size());
            node._children = children;
            for (Int2ObjectMap.Entry entry : timeColumnRangeMap.int2ObjectEntrySet()) {
                int timeValue = entry.getIntKey();
                Pairs.IntPair range = (Pairs.IntPair)entry.getValue();
                StarTreeBuilderUtils.TreeNode child = new StarTreeBuilderUtils.TreeNode();
                ++this._numNodes;
                children.put(timeValue, child);
                child._dimensionId = timeColumnId;
                child._dimensionValue = timeValue;
                child._startDocId = range.getLeft();
                child._endDocId = range.getRight();
            }
        } else {
            for (StarTreeBuilderUtils.TreeNode child : node._children.values()) {
                this.splitLeafNodesOnTimeColumnHelper(dataTable, child, level + 1, timeColumnId);
            }
        }
    }

    private int[] getNewSortOrder(int value, int newIndex) {
        int length = this._sortOrder.length;
        int[] newSortOrder = new int[length];
        int sortOrderIndex = 0;
        for (int i = 0; i < length; ++i) {
            if (i == newIndex) {
                newSortOrder[i] = value;
                continue;
            }
            if (this._sortOrder[sortOrderIndex] == value) {
                // empty if block
            }
            int n = ++sortOrderIndex;
            ++sortOrderIndex;
            newSortOrder[i] = this._sortOrder[n];
        }
        return newSortOrder;
    }

    private Set<Integer> computeDefaultDimensionsToSkipMaterialization() {
        HashSet<Integer> skipDimensions = new HashSet<Integer>();
        for (int i = 0; i < this._numDimensions; ++i) {
            if (this._dimensionDictionaries.get(i).size() <= this._skipMaterializationCardinalityThreshold) continue;
            skipDimensions.add(i);
        }
        return skipDimensions;
    }

    private List<Integer> computeDefaultSplitOrder() {
        ArrayList<Integer> defaultSplitOrder = new ArrayList<Integer>();
        HashSet<String> timeDimensions = new HashSet<String>(this._schema.getDateTimeNames());
        String timeColumnName = this._schema.getTimeColumnName();
        if (timeColumnName != null) {
            timeDimensions.add(timeColumnName);
        }
        for (int i = 0; i < this._numDimensions; ++i) {
            if (this._skipMaterializationDimensions.contains(i) || timeDimensions.contains(this._dimensionNames.get(i))) continue;
            defaultSplitOrder.add(i);
        }
        defaultSplitOrder.sort((o1, o2) -> this._dimensionDictionaries.get((int)o2).size() - this._dimensionDictionaries.get((int)o1).size());
        return defaultSplitOrder;
    }

    private void constructStarTree(StarTreeBuilderUtils.TreeNode node, int startDocId, int endDocId, int level) throws IOException {
        Int2ObjectMap<Pairs.IntPair> dimensionRangeMap;
        if (level == this._dimensionsSplitOrder.size()) {
            return;
        }
        int splitDimensionId = this._dimensionsSplitOrder.get(level);
        LOGGER.debug("Building tree at level: {} from startDoc: {} endDocId: {} splitting on dimension id: {}", new Object[]{level, startDocId, endDocId, splitDimensionId});
        int numDocs = endDocId - startDocId;
        try (StarTreeDataTable dataTable = new StarTreeDataTable(PinotDataBuffer.mapFile(this._dataFile, true, (long)startDocId * this._docSizeLong, (long)numDocs * this._docSizeLong, PinotDataBuffer.NATIVE_ORDER, "OffHeapStarTreeBuilder#constructStarTree: data buffer"), this._dimensionSize, this._metricSize, startDocId);){
            dimensionRangeMap = dataTable.groupOnDimension(startDocId, endDocId, splitDimensionId);
        }
        LOGGER.debug("Group stats:{}", dimensionRangeMap);
        node._childDimensionId = splitDimensionId;
        HashMap<Integer, StarTreeBuilderUtils.TreeNode> children = new HashMap<Integer, StarTreeBuilderUtils.TreeNode>(dimensionRangeMap.size() + 1);
        node._children = children;
        for (Int2ObjectMap.Entry entry : dimensionRangeMap.int2ObjectEntrySet()) {
            int childEndDocId;
            int childStartDocId;
            int childDimensionValue = entry.getIntKey();
            StarTreeBuilderUtils.TreeNode child = new StarTreeBuilderUtils.TreeNode();
            ++this._numNodes;
            children.put(childDimensionValue, child);
            Pairs.IntPair range = (Pairs.IntPair)dimensionRangeMap.get(childDimensionValue);
            child._startDocId = childStartDocId = range.getLeft();
            child._endDocId = childEndDocId = range.getRight();
            if (childEndDocId - childStartDocId <= this._maxNumLeafRecords) continue;
            this.constructStarTree(child, childStartDocId, childEndDocId, level + 1);
        }
        if (this._skipStarNodeCreationDimensions != null && this._skipStarNodeCreationDimensions.contains(splitDimensionId)) {
            return;
        }
        StarTreeBuilderUtils.TreeNode starChild = new StarTreeBuilderUtils.TreeNode();
        ++this._numNodes;
        children.put(-1, starChild);
        starChild._dimensionId = splitDimensionId;
        starChild._dimensionValue = -1;
        Iterator<Pair<DimensionBuffer, MetricBuffer>> iterator = this.getUniqueCombinations(startDocId, endDocId, splitDimensionId);
        int starChildStartDocId = this._numRawDocs + this._numAggregatedDocs;
        while (iterator.hasNext()) {
            Pair<DimensionBuffer, MetricBuffer> next = iterator.next();
            DimensionBuffer dimensions = next.getLeft();
            MetricBuffer metrics = next.getRight();
            this.appendToAggBuffer(dimensions, metrics);
        }
        this._outputStream.flush();
        int starChildEndDocId = this._numRawDocs + this._numAggregatedDocs;
        starChild._startDocId = starChildStartDocId;
        starChild._endDocId = starChildEndDocId;
        if (starChildEndDocId - starChildStartDocId > this._maxNumLeafRecords) {
            this.constructStarTree(starChild, starChildStartDocId, starChildEndDocId, level + 1);
        }
    }

    private Iterator<Pair<DimensionBuffer, MetricBuffer>> getUniqueCombinations(final int startDocId, final int endDocId, int dimensionIdToRemove) throws IOException {
        PinotDataBuffer tempBuffer;
        long tempBufferSize = (long)(endDocId - startDocId) * this._docSizeLong;
        if (tempBufferSize > 500000000L) {
            File tempFile = new File(this._tempDir, startDocId + "_" + endDocId + ".unique.tmp");
            try (FileChannel src = new RandomAccessFile(this._dataFile, "r").getChannel();
                 FileChannel dest = new RandomAccessFile(tempFile, "rw").getChannel();){
                FileUtils.transferBytes(src, (long)startDocId * this._docSizeLong, tempBufferSize, dest);
            }
            tempBuffer = PinotDataBuffer.mapFile(tempFile, false, 0L, tempBufferSize, PinotDataBuffer.NATIVE_ORDER, "OffHeapStarTreeBuilder#getUniqueCombinations: temp buffer");
        } else {
            tempBuffer = PinotDataBuffer.loadFile(this._dataFile, (long)startDocId * this._docSizeLong, tempBufferSize, PinotDataBuffer.NATIVE_ORDER, "OffHeapStarTreeBuilder#getUniqueCombinations: temp buffer");
        }
        final StarTreeDataTable dataTable = new StarTreeDataTable(tempBuffer, this._dimensionSize, this._metricSize, startDocId);
        this._dataTablesToClose.add(dataTable);
        if (!this._skipMaterializationDimensions.isEmpty() && !this._excludeSkipMaterializationDimensionsForStarTreeIndex) {
            for (int dimensionIdToSkip : this._skipMaterializationDimensions) {
                dataTable.setDimensionValue(dimensionIdToSkip, -1);
            }
        }
        dataTable.setDimensionValue(dimensionIdToRemove, -1);
        dataTable.sort(startDocId, endDocId, this._sortOrder);
        return new Iterator<Pair<DimensionBuffer, MetricBuffer>>(){
            final Iterator<Pair<byte[], byte[]>> _iterator;
            DimensionBuffer _currentDimensions;
            MetricBuffer _currentMetrics;
            boolean _hasNext;
            {
                this._iterator = dataTable.iterator(startDocId, endDocId);
                this._hasNext = true;
            }

            @Override
            public boolean hasNext() {
                return this._hasNext;
            }

            @Override
            public Pair<DimensionBuffer, MetricBuffer> next() {
                while (this._iterator.hasNext()) {
                    Pair<byte[], byte[]> next = this._iterator.next();
                    byte[] dimensionBytes = next.getLeft();
                    MetricBuffer metrics = MetricBuffer.fromBytes(next.getRight(), OffHeapStarTreeBuilder.this._metricFieldSpecs);
                    if (this._currentDimensions == null) {
                        this._currentDimensions = DimensionBuffer.fromBytes(dimensionBytes);
                        this._currentMetrics = metrics;
                        continue;
                    }
                    if (this._currentDimensions.hasSameBytes(dimensionBytes)) {
                        this._currentMetrics.aggregate(metrics);
                        continue;
                    }
                    ImmutablePair<DimensionBuffer, MetricBuffer> ret = new ImmutablePair<DimensionBuffer, MetricBuffer>(this._currentDimensions, this._currentMetrics);
                    this._currentDimensions = DimensionBuffer.fromBytes(dimensionBytes);
                    this._currentMetrics = metrics;
                    return ret;
                }
                this._hasNext = false;
                OffHeapStarTreeBuilder.this.closeDataTable(dataTable);
                return new ImmutablePair<DimensionBuffer, MetricBuffer>(this._currentDimensions, this._currentMetrics);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<GenericRow> iterator(final int startDocId, final int endDocId) throws IOException {
        final StarTreeDataTable dataTable = new StarTreeDataTable(PinotDataBuffer.mapFile(this._dataFile, true, (long)startDocId * this._docSizeLong, (long)(endDocId - startDocId) * this._docSizeLong, PinotDataBuffer.NATIVE_ORDER, "OffHeapStarTreeBuilder#iterator: data buffer"), this._dimensionSize, this._metricSize, startDocId);
        this._dataTablesToClose.add(dataTable);
        return new Iterator<GenericRow>(){
            private final Iterator<Pair<byte[], byte[]>> _iterator;
            {
                this._iterator = dataTable.iterator(startDocId, endDocId);
            }

            @Override
            public boolean hasNext() {
                boolean hasNext = this._iterator.hasNext();
                if (!hasNext) {
                    OffHeapStarTreeBuilder.this.closeDataTable(dataTable);
                }
                return hasNext;
            }

            @Override
            public GenericRow next() {
                Pair<byte[], byte[]> pair = this._iterator.next();
                DimensionBuffer dimensions = DimensionBuffer.fromBytes(pair.getLeft());
                MetricBuffer metrics = MetricBuffer.fromBytes(pair.getRight(), OffHeapStarTreeBuilder.this._metricFieldSpecs);
                return OffHeapStarTreeBuilder.this.toGenericRow(dimensions, metrics);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void closeDataTable(StarTreeDataTable dataTable) {
        try {
            dataTable.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this._dataTablesToClose.remove(dataTable);
    }

    private GenericRow toGenericRow(DimensionBuffer dimensions, MetricBuffer metrics) {
        int i;
        GenericRow row = new GenericRow();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (i = 0; i < this._numDimensions; ++i) {
            String dimensionName = this._dimensionNames.get(i);
            int dictId = dimensions.getDictId(i);
            if (dictId == -1) {
                map.put(dimensionName, this._dimensionStarValues.get(i));
                continue;
            }
            map.put(dimensionName, this._dimensionDictionaries.get(i).inverse().get(dictId));
        }
        for (i = 0; i < this._numMetrics; ++i) {
            map.put(this._metricNames.get(i), metrics.getValueConformToDataType(i));
        }
        row.init(map);
        return row;
    }

    @Override
    public void serializeTree(File starTreeFile, Map<String, ColumnIndexCreationInfo> indexCreationInfoMap) throws IOException {
        this.updateTree(this._rootNode, indexCreationInfoMap);
        StarTreeBuilderUtils.serializeTree(starTreeFile, this._rootNode, this._dimensionNames.toArray(new String[this._numDimensions]), this._numNodes);
        LOGGER.info("Finish serializing star tree into file: {}", (Object)starTreeFile);
    }

    private void updateTree(StarTreeBuilderUtils.TreeNode node, Map<String, ColumnIndexCreationInfo> indexCreationInfoMap) {
        Map<Integer, StarTreeBuilderUtils.TreeNode> children = node._children;
        if (children != null) {
            HashMap<Integer, StarTreeBuilderUtils.TreeNode> newChildren = new HashMap<Integer, StarTreeBuilderUtils.TreeNode>(children.size());
            node._children = newChildren;
            int childDimensionId = node._childDimensionId;
            BiMap<Integer, Object> dimensionDictionary = this._dimensionDictionaries.get(childDimensionId).inverse();
            String childDimensionName = this._dimensionNames.get(childDimensionId);
            Object segmentDictionary = indexCreationInfoMap.get(childDimensionName).getSortedUniqueElementsArray();
            for (Map.Entry<Integer, StarTreeBuilderUtils.TreeNode> entry : children.entrySet()) {
                int childDimensionValue = entry.getKey();
                StarTreeBuilderUtils.TreeNode childNode = entry.getValue();
                int dictId = -1;
                if (childDimensionValue != -1) {
                    childNode._dimensionValue = dictId = OffHeapStarTreeBuilder.indexOf(segmentDictionary, dimensionDictionary.get(childDimensionValue));
                }
                newChildren.put(dictId, childNode);
                this.updateTree(childNode, indexCreationInfoMap);
            }
        }
    }

    private static int indexOf(Object array, Object value) {
        if (array instanceof int[]) {
            return Arrays.binarySearch((int[])array, (Integer)value);
        }
        if (array instanceof long[]) {
            return Arrays.binarySearch((long[])array, (Long)value);
        }
        if (array instanceof float[]) {
            return Arrays.binarySearch((float[])array, ((Float)value).floatValue());
        }
        if (array instanceof double[]) {
            return Arrays.binarySearch((double[])array, (Double)value);
        }
        if (array instanceof String[]) {
            return Arrays.binarySearch((String[])array, value);
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTotalRawDocumentCount() {
        return this._numRawDocs;
    }

    @Override
    public int getTotalAggregateDocumentCount() {
        return this._numAggregatedDocs;
    }

    @Override
    public List<String> getDimensionsSplitOrder() {
        ArrayList<String> dimensionsSplitOrder = new ArrayList<String>(this._dimensionsSplitOrder.size());
        for (int dimensionId : this._dimensionsSplitOrder) {
            dimensionsSplitOrder.add(this._dimensionNames.get(dimensionId));
        }
        return dimensionsSplitOrder;
    }

    @Override
    public Set<String> getSkipMaterializationDimensions() {
        HashSet<String> skipMaterializationDimensions = new HashSet<String>(this._skipMaterializationDimensions.size());
        for (int dimensionId : this._skipMaterializationDimensions) {
            skipMaterializationDimensions.add(this._dimensionNames.get(dimensionId));
        }
        return skipMaterializationDimensions;
    }

    @Override
    public List<String> getDimensionNames() {
        return this._dimensionNames;
    }

    @Override
    public List<BiMap<Object, Integer>> getDimensionDictionaries() {
        return this._dimensionDictionaries;
    }

    @Override
    public void close() throws IOException {
        this._outputStream.close();
        for (StarTreeDataTable dataTable : this._dataTablesToClose) {
            dataTable.close();
        }
        this._dataTablesToClose.clear();
        org.apache.pinot.$internal.org.apache.commons.io.FileUtils.deleteDirectory(this._tempDir);
    }
}

