/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.executor;

import javax.annotation.Nonnull;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.DefaultGroupByExecutor;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.StarTreeUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;
import org.apache.pinot.common.request.GroupBy;

public class StarTreeGroupByExecutor
extends DefaultGroupByExecutor {
    public StarTreeGroupByExecutor(@Nonnull AggregationFunctionContext[] functionContexts, @Nonnull GroupBy groupBy, int maxInitialResultHolderCapacity, int numGroupsLimit, @Nonnull .TransformOperator transformOperator) {
        super(StarTreeUtils.createStarTreeFunctionContexts(functionContexts), groupBy, maxInitialResultHolderCapacity, numGroupsLimit, transformOperator);
    }

    @Override
    protected void aggregate(@Nonnull TransformBlock transformBlock, int length, int functionIndex) {
        AggregationFunction function = this._functions[functionIndex];
        .GroupByResultHolder resultHolder = this._resultHolders[functionIndex];
        if (function.getType() == AggregationFunctionType.COUNT) {
            BlockValSet blockValueSet = transformBlock.getBlockValueSet(AggregationFunctionColumnPair.COUNT_STAR_COLUMN_NAME);
            if (this._hasMVGroupByExpression) {
                function.aggregateGroupByMV(length, this._mvGroupKeys, resultHolder, blockValueSet);
            } else {
                function.aggregateGroupBySV(length, this._svGroupKeys, resultHolder, blockValueSet);
            }
        } else {
            BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._aggregationExpressions[functionIndex].getValue());
            if (this._hasMVGroupByExpression) {
                function.aggregateGroupByMV(length, this._mvGroupKeys, resultHolder, blockValueSet);
            } else {
                function.aggregateGroupBySV(length, this._svGroupKeys, resultHolder, blockValueSet);
            }
        }
    }
}

