/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.operator;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Predicate;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.EmptyFilterBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.BitmapBasedFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.FilterOperatorUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.PredicateEvaluatorProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.StarTree;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.StarTreeNode;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.StarTreeV2;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class StarTreeFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "StarTreeFilterOperator";
    private static final int USE_SCAN_TO_TRAVERSE_NODES_THRESHOLD = 10;
    private final StarTreeV2 _starTreeV2;
    private final Set<String> _groupByColumns;
    private final Map<String, List<PredicateEvaluator>> _predicateEvaluatorsMap;
    private final Map<String, IntSet> _matchingDictIdsMap;
    private final Map<String, String> _debugOptions;
    boolean _resultEmpty = false;

    public StarTreeFilterOperator(StarTreeV2 starTreeV2, @Nullable FilterQueryTree rootFilterNode, @Nullable Set<String> groupByColumns, @Nullable Map<String, String> debugOptions) {
        this._starTreeV2 = starTreeV2;
        this._groupByColumns = groupByColumns != null ? new HashSet<String>(groupByColumns) : Collections.emptySet();
        this._debugOptions = debugOptions;
        if (rootFilterNode != null) {
            this._predicateEvaluatorsMap = new HashMap<String, List<PredicateEvaluator>>();
            this._matchingDictIdsMap = new HashMap<String, IntSet>();
            Map<String, List<Predicate>> predicatesMap = this.getPredicatesMap(rootFilterNode);
            for (Map.Entry<String, List<Predicate>> entry : predicatesMap.entrySet()) {
                String columnName = entry.getKey();
                List<Predicate> predicates = entry.getValue();
                ArrayList<PredicateEvaluator> predicateEvaluators = new ArrayList<PredicateEvaluator>();
                .DataSource dataSource = starTreeV2.getDataSource(columnName);
                for (Predicate predicate : predicates) {
                    PredicateEvaluator predicateEvaluator = PredicateEvaluatorProvider.getPredicateEvaluator(predicate, dataSource);
                    if (predicateEvaluator.isAlwaysFalse()) {
                        this._resultEmpty = true;
                        return;
                    }
                    if (predicateEvaluator.isAlwaysTrue()) continue;
                    predicateEvaluators.add(predicateEvaluator);
                }
                if (predicateEvaluators.isEmpty()) continue;
                this._predicateEvaluatorsMap.put(columnName, predicateEvaluators);
            }
            this._groupByColumns.removeAll(this._predicateEvaluatorsMap.keySet());
        } else {
            this._predicateEvaluatorsMap = Collections.emptyMap();
            this._matchingDictIdsMap = Collections.emptyMap();
        }
    }

    private Map<String, List<Predicate>> getPredicatesMap(@Nonnull FilterQueryTree rootFilterNode) {
        HashMap<String, List<Predicate>> predicatesMap = new HashMap<String, List<Predicate>>();
        LinkedList<FilterQueryTree> queue = new LinkedList<FilterQueryTree>();
        queue.add(rootFilterNode);
        while (!queue.isEmpty()) {
            FilterQueryTree filterNode = (FilterQueryTree)queue.remove();
            List<FilterQueryTree> children = filterNode.getChildren();
            if (children == null) {
                String columnName = filterNode.getColumn();
                Predicate predicate = Predicate.newPredicate(filterNode);
                predicatesMap.computeIfAbsent(columnName, k -> new ArrayList()).add(predicate);
                continue;
            }
            queue.addAll(children);
        }
        return predicatesMap;
    }

    @Override
    public FilterBlock getNextBlock() {
        if (this._resultEmpty) {
            return EmptyFilterBlock.getInstance();
        }
        return (FilterBlock)this.getFilterOperator().nextBlock();
    }

    @Override
    public boolean isResultEmpty() {
        return this._resultEmpty;
    }

    @Override
    public boolean isResultMatchingAll() {
        return false;
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    private BaseFilterOperator getFilterOperator() {
        StarTreeResult starTreeResult = this.traverseStarTree();
        if (starTreeResult == null) {
            return EmptyFilterOperator.getInstance();
        }
        int numDocs = this._starTreeV2.getMetadata().getNumDocs();
        ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(1 + starTreeResult._remainingPredicateColumns.size());
        childFilterOperators.add(new BitmapBasedFilterOperator(new ImmutableRoaringBitmap[]{starTreeResult._matchedDocIds}, 0, numDocs - 1, false));
        for (String remainingPredicateColumn : starTreeResult._remainingPredicateColumns) {
            List<PredicateEvaluator> predicateEvaluators = this._predicateEvaluatorsMap.get(remainingPredicateColumn);
            .DataSource dataSource = this._starTreeV2.getDataSource(remainingPredicateColumn);
            for (PredicateEvaluator predicateEvaluator : predicateEvaluators) {
                childFilterOperators.add(FilterOperatorUtils.getLeafFilterOperator(predicateEvaluator, dataSource, numDocs));
            }
        }
        return FilterOperatorUtils.getAndFilterOperator(childFilterOperators, numDocs, this._debugOptions);
    }

    private StarTreeResult traverseStarTree() {
        MutableRoaringBitmap matchedDocIds = new MutableRoaringBitmap();
        HashSet<String> remainingPredicateColumns = new HashSet<String>();
        StarTree starTree = this._starTreeV2.getStarTree();
        List<String> dimensionNames = starTree.getDimensionNames();
        StarTreeNode starTreeRootNode = starTree.getRoot();
        LinkedList<SearchEntry> queue = new LinkedList<SearchEntry>();
        queue.add(new SearchEntry(starTreeRootNode, this._predicateEvaluatorsMap.keySet(), this._groupByColumns));
        while (!queue.isEmpty()) {
            Set<String> newRemainingGroupByColumns;
            SearchEntry searchEntry = (SearchEntry)queue.remove();
            StarTreeNode starTreeNode = searchEntry._starTreeNode;
            if (searchEntry._remainingPredicateColumns.isEmpty() && searchEntry._remainingGroupByColumns.isEmpty()) {
                matchedDocIds.add(starTreeNode.getAggregatedDocId());
                continue;
            }
            if (starTreeNode.isLeaf()) {
                matchedDocIds.add(starTreeNode.getStartDocId(), starTreeNode.getEndDocId());
                remainingPredicateColumns.addAll(searchEntry._remainingPredicateColumns);
                continue;
            }
            String nextDimension = dimensionNames.get(starTreeNode.getChildDimensionId());
            if (searchEntry._remainingPredicateColumns.contains(nextDimension)) {
                int numChildren;
                int numMatchingDictIds;
                HashSet<String> newRemainingPredicateColumns = new HashSet<String>(searchEntry._remainingPredicateColumns);
                newRemainingPredicateColumns.remove(nextDimension);
                IntSet matchingDictIds = this._matchingDictIdsMap.get(nextDimension);
                if (matchingDictIds == null) {
                    matchingDictIds = this.getMatchingDictIds(this._predicateEvaluatorsMap.get(nextDimension));
                    if (matchingDictIds.isEmpty()) {
                        return null;
                    }
                    this._matchingDictIdsMap.put(nextDimension, matchingDictIds);
                }
                if ((numMatchingDictIds = matchingDictIds.size()) * 10 > (numChildren = starTreeNode.getNumChildren())) {
                    Iterator<? extends StarTreeNode> childrenIterator = starTreeNode.getChildrenIterator();
                    while (childrenIterator.hasNext()) {
                        StarTreeNode childNode = childrenIterator.next();
                        if (!matchingDictIds.contains(childNode.getDimensionValue())) continue;
                        queue.add(new SearchEntry(childNode, newRemainingPredicateColumns, searchEntry._remainingGroupByColumns));
                    }
                    continue;
                }
                IntIterator iterator = matchingDictIds.iterator();
                while (iterator.hasNext()) {
                    int matchingDictId = iterator.nextInt();
                    StarTreeNode childNode = starTreeNode.getChildForDimensionValue(matchingDictId);
                    if (childNode == null) continue;
                    queue.add(new SearchEntry(childNode, newRemainingPredicateColumns, searchEntry._remainingGroupByColumns));
                }
                continue;
            }
            if (!searchEntry._remainingGroupByColumns.contains(nextDimension)) {
                StarTreeNode starNode = starTreeNode.getChildForDimensionValue(-1);
                if (starNode != null) {
                    queue.add(new SearchEntry(starNode, searchEntry._remainingPredicateColumns, searchEntry._remainingGroupByColumns));
                    continue;
                }
                newRemainingGroupByColumns = searchEntry._remainingGroupByColumns;
            } else {
                newRemainingGroupByColumns = new HashSet<String>(searchEntry._remainingGroupByColumns);
                newRemainingGroupByColumns.remove(nextDimension);
            }
            Iterator<? extends StarTreeNode> childrenIterator = starTreeNode.getChildrenIterator();
            while (childrenIterator.hasNext()) {
                StarTreeNode childNode = childrenIterator.next();
                if (childNode.getDimensionValue() == -1) continue;
                queue.add(new SearchEntry(childNode, searchEntry._remainingPredicateColumns, newRemainingGroupByColumns));
            }
        }
        return new StarTreeResult((ImmutableRoaringBitmap)matchedDocIds, remainingPredicateColumns);
    }

    private IntSet getMatchingDictIds(List<PredicateEvaluator> predicateEvaluators) {
        predicateEvaluators.sort(new Comparator<PredicateEvaluator>(){

            @Override
            public int compare(PredicateEvaluator o1, PredicateEvaluator o2) {
                return this.getPriority(o1) - this.getPriority(o2);
            }

            int getPriority(PredicateEvaluator predicateEvaluator) {
                switch (predicateEvaluator.getPredicateType()) {
                    case EQ: {
                        return 1;
                    }
                    case IN: {
                        return 2;
                    }
                    case RANGE: {
                        return 3;
                    }
                    case NOT_IN: 
                    case NEQ: {
                        return 4;
                    }
                    case REGEXP_LIKE: {
                        return 5;
                    }
                }
                throw new UnsupportedOperationException();
            }
        });
        IntOpenHashSet matchingDictIds = new IntOpenHashSet();
        PredicateEvaluator firstPredicateEvaluator = predicateEvaluators.get(0);
        for (int matchingDictId : firstPredicateEvaluator.getMatchingDictIds()) {
            matchingDictIds.add(matchingDictId);
        }
        int numPredicateEvaluators = predicateEvaluators.size();
        for (int i = 1; i < numPredicateEvaluators; ++i) {
            if (matchingDictIds.isEmpty()) {
                return matchingDictIds;
            }
            PredicateEvaluator predicateEvaluator = predicateEvaluators.get(i);
            IntIterator iterator = matchingDictIds.iterator();
            while (iterator.hasNext()) {
                if (predicateEvaluator.applySV(iterator.nextInt())) continue;
                iterator.remove();
            }
        }
        return matchingDictIds;
    }

    private static class StarTreeResult {
        final ImmutableRoaringBitmap _matchedDocIds;
        final Set<String> _remainingPredicateColumns;

        StarTreeResult(@Nonnull ImmutableRoaringBitmap matchedDocIds, @Nonnull Set<String> remainingPredicateColumns) {
            this._matchedDocIds = matchedDocIds;
            this._remainingPredicateColumns = remainingPredicateColumns;
        }
    }

    private static class SearchEntry {
        final StarTreeNode _starTreeNode;
        final Set<String> _remainingPredicateColumns;
        final Set<String> _remainingGroupByColumns;

        SearchEntry(@Nonnull StarTreeNode starTreeNode, @Nonnull Set<String> remainingPredicateColumns, @Nonnull Set<String> remainingGroupByColumns) {
            this._starTreeNode = starTreeNode;
            this._remainingPredicateColumns = remainingPredicateColumns;
            this._remainingGroupByColumns = remainingGroupByColumns;
        }
    }
}

