/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.plan;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.plan.StarTreeDocIdSetPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.StarTreeV2;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarTreeProjectionPlanNode
implements PlanNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(StarTreeProjectionPlanNode.class);
    private final Map<String, .DataSource> _dataSourceMap;
    private final StarTreeDocIdSetPlanNode _starTreeDocIdSetPlanNode;

    public StarTreeProjectionPlanNode(StarTreeV2 starTreeV2, Set<String> projectionColumns, @Nullable FilterQueryTree rootFilterNode, @Nullable Set<String> groupByColumns, @Nullable Map<String, String> debugOptions) {
        this._dataSourceMap = new HashMap<String, .DataSource>(projectionColumns.size());
        for (String projectionColumn : projectionColumns) {
            this._dataSourceMap.put(projectionColumn, starTreeV2.getDataSource(projectionColumn));
        }
        this._starTreeDocIdSetPlanNode = new StarTreeDocIdSetPlanNode(starTreeV2, rootFilterNode, groupByColumns, debugOptions);
    }

    @Override
    public ProjectionOperator run() {
        return new ProjectionOperator(this._dataSourceMap, this._starTreeDocIdSetPlanNode.run());
    }

    @Override
    public void showTree(String prefix) {
        LOGGER.debug(prefix + "StarTree Projection Plan Node:");
        LOGGER.debug(prefix + "Operator: ProjectionOperator");
        LOGGER.debug(prefix + "Argument 0: Data Sources - " + this._dataSourceMap.keySet());
        LOGGER.debug(prefix + "Argument 1: StarTreeDocIdSetPlanNode -");
        this._starTreeDocIdSetPlanNode.showTree(prefix + "    ");
    }
}

