/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.plan;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.plan.StarTreeProjectionPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.StarTreeV2;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarTreeTransformPlanNode
implements PlanNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(StarTreeTransformPlanNode.class);
    private final Set<TransformExpressionTree> _groupByExpressions;
    private final StarTreeProjectionPlanNode _starTreeProjectionPlanNode;

    public StarTreeTransformPlanNode(StarTreeV2 starTreeV2, Set<AggregationFunctionColumnPair> aggregationFunctionColumnPairs, @Nullable Set<TransformExpressionTree> groupByExpressions, @Nullable FilterQueryTree rootFilterNode, @Nullable Map<String, String> debugOptions) {
        HashSet<String> groupByColumns;
        HashSet<String> projectionColumns = new HashSet<String>();
        for (AggregationFunctionColumnPair aggregationFunctionColumnPair : aggregationFunctionColumnPairs) {
            projectionColumns.add(aggregationFunctionColumnPair.toColumnName());
        }
        if (groupByExpressions != null) {
            this._groupByExpressions = groupByExpressions;
            groupByColumns = new HashSet<String>();
            for (TransformExpressionTree groupByExpression : groupByExpressions) {
                groupByExpression.getColumns(groupByColumns);
            }
            projectionColumns.addAll(groupByColumns);
        } else {
            this._groupByExpressions = Collections.emptySet();
            groupByColumns = null;
        }
        this._starTreeProjectionPlanNode = new StarTreeProjectionPlanNode(starTreeV2, projectionColumns, rootFilterNode, groupByColumns, debugOptions);
    }

    @Override
    public TransformOperator run() {
        return new TransformOperator(this._starTreeProjectionPlanNode.run(), this._groupByExpressions);
    }

    @Override
    public void showTree(String prefix) {
        LOGGER.debug(prefix + "StarTree Transform Plan Node:");
        LOGGER.debug(prefix + "Operator: TransformOperator");
        LOGGER.debug(prefix + "Argument 0: Group-by Expressions - " + this._groupByExpressions);
        LOGGER.debug(prefix + "Argument 1: StarTreeProjectionPlanNode -");
        this._starTreeProjectionPlanNode.showTree(prefix + "    ");
    }
}

