/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.v2;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;

public class AggregationFunctionColumnPair {
    public static final String DELIMITER = "__";
    public static final String STAR = "*";
    public static final AggregationFunctionColumnPair COUNT_STAR = new AggregationFunctionColumnPair(AggregationFunctionType.COUNT, "*");
    public static final String COUNT_STAR_COLUMN_NAME = COUNT_STAR.toColumnName();
    private final AggregationFunctionType _functionType;
    private final String _column;

    public AggregationFunctionColumnPair(@Nonnull AggregationFunctionType functionType, @Nonnull String column) {
        this._functionType = functionType;
        this._column = functionType == AggregationFunctionType.COUNT ? STAR : column;
    }

    @Nonnull
    public AggregationFunctionType getFunctionType() {
        return this._functionType;
    }

    @Nonnull
    public String getColumn() {
        return this._column;
    }

    @Nonnull
    public String toColumnName() {
        return this._functionType.getName() + DELIMITER + this._column;
    }

    @Nonnull
    public static AggregationFunctionColumnPair fromColumnName(@Nonnull String columnName) {
        String[] parts = columnName.split(DELIMITER, 2);
        AggregationFunctionType functionType = AggregationFunctionType.valueOf(parts[0].toUpperCase());
        if (functionType == AggregationFunctionType.COUNT) {
            return COUNT_STAR;
        }
        return new AggregationFunctionColumnPair(functionType, parts[1]);
    }

    public int hashCode() {
        return 31 * this._functionType.hashCode() + this._column.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AggregationFunctionColumnPair) {
            AggregationFunctionColumnPair anotherPair = (AggregationFunctionColumnPair)obj;
            return this._functionType == anotherPair._functionType && this._column.equals(anotherPair._column);
        }
        return false;
    }
}

