/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.core.data.aggregator.ValueAggregator;
import org.apache.pinot.$internal.org.apache.pinot.core.data.aggregator.ValueAggregatorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.PinotSegmentColumnReader;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.ForwardIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SingleValueRawIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.fwd.SingleValueFixedByteRawIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.fwd.SingleValueUnsortedForwardIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.fwd.SingleValueVarByteRawIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.StarTreeBuilderUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder.SingleTreeBuilder;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseSingleTreeBuilder
implements SingleTreeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSingleTreeBuilder.class);
    final StarTreeV2BuilderConfig _builderConfig;
    final File _outputDir;
    final ImmutableSegment _segment;
    final Configuration _metadataProperties;
    final int _numDimensions;
    final String[] _dimensionsSplitOrder;
    final Set<Integer> _skipStarNodeCreationForDimensions;
    final PinotSegmentColumnReader[] _dimensionReaders;
    final int _numMetrics;
    final String[] _metrics;
    final AggregationFunctionColumnPair[] _functionColumnPairs;
    final ValueAggregator[] _valueAggregators;
    final PinotSegmentColumnReader[] _metricReaders;
    final FieldSpec.DataType[] _metricDataTypes;
    final int _maxLeafRecords;
    final StarTreeBuilderUtils.TreeNode _rootNode = this.getNewNode();
    int _numDocs;
    int _numNodes;

    BaseSingleTreeBuilder(StarTreeV2BuilderConfig builderConfig, File outputDir, ImmutableSegment segment, Configuration metadataProperties) {
        this._builderConfig = builderConfig;
        this._outputDir = outputDir;
        this._segment = segment;
        this._metadataProperties = metadataProperties;
        List<String> dimensionsSplitOrder = builderConfig.getDimensionsSplitOrder();
        this._numDimensions = dimensionsSplitOrder.size();
        this._dimensionsSplitOrder = new String[this._numDimensions];
        this._skipStarNodeCreationForDimensions = new HashSet<Integer>();
        this._dimensionReaders = new PinotSegmentColumnReader[this._numDimensions];
        Set<String> skipStarNodeCreationForDimensions = builderConfig.getSkipStarNodeCreationForDimensions();
        for (int i = 0; i < this._numDimensions; ++i) {
            String dimension;
            this._dimensionsSplitOrder[i] = dimension = dimensionsSplitOrder.get(i);
            if (skipStarNodeCreationForDimensions.contains(dimension)) {
                this._skipStarNodeCreationForDimensions.add(i);
            }
            this._dimensionReaders[i] = new PinotSegmentColumnReader(segment, dimension);
            Preconditions.checkState(this._dimensionReaders[i].hasDictionary(), "Dimension: " + dimension + " does not have dictionary");
        }
        Set<AggregationFunctionColumnPair> functionColumnPairs = builderConfig.getFunctionColumnPairs();
        this._numMetrics = functionColumnPairs.size();
        this._metrics = new String[this._numMetrics];
        this._functionColumnPairs = new AggregationFunctionColumnPair[this._numMetrics];
        this._valueAggregators = new ValueAggregator[this._numMetrics];
        this._metricDataTypes = new FieldSpec.DataType[this._numMetrics];
        this._metricReaders = new PinotSegmentColumnReader[this._numMetrics];
        Schema schema = segment.getSegmentMetadata().getSchema();
        int index = 0;
        for (AggregationFunctionColumnPair functionColumnPair : functionColumnPairs) {
            this._metrics[index] = functionColumnPair.toColumnName();
            this._functionColumnPairs[index] = functionColumnPair;
            this._valueAggregators[index] = ValueAggregatorFactory.getValueAggregator(functionColumnPair.getFunctionType());
            if (this._valueAggregators[index].getAggregationType() != AggregationFunctionType.COUNT) {
                String column = functionColumnPair.getColumn();
                this._metricDataTypes[index] = schema.getFieldSpecFor(column).getDataType();
                this._metricReaders[index] = new PinotSegmentColumnReader(segment, column);
            }
            ++index;
        }
        this._maxLeafRecords = builderConfig.getMaxLeafRecords();
    }

    abstract void appendRecord(Record var1) throws IOException;

    abstract Record getStarTreeRecord(int var1) throws IOException;

    abstract int getDimensionValue(int var1, int var2) throws IOException;

    abstract Iterator<Record> sortAndAggregateSegmentRecords(int var1) throws IOException;

    abstract Iterator<Record> generateRecordsForStarNode(int var1, int var2, int var3) throws IOException;

    int[] getSegmentRecordDimensions(int docId) {
        int[] dimensions = new int[this._numDimensions];
        for (int i = 0; i < this._numDimensions; ++i) {
            dimensions[i] = this._dimensionReaders[i].getDictionaryId(docId);
        }
        return dimensions;
    }

    Record getSegmentRecord(int docId) {
        int[] dimensions = this.getSegmentRecordDimensions(docId);
        Object[] metrics = new Object[this._numMetrics];
        for (int i = 0; i < this._numMetrics; ++i) {
            if (this._metricReaders[i] == null) continue;
            metrics[i] = this._metricReaders[i].readSV(docId, this._metricDataTypes[i]);
        }
        return new Record(dimensions, metrics);
    }

    Record mergeSegmentRecord(@Nullable Record aggregatedRecord, Record segmentRecord) {
        if (aggregatedRecord == null) {
            int[] dimensions = Arrays.copyOf(segmentRecord._dimensions, this._numDimensions);
            Object[] metrics = new Object[this._numMetrics];
            for (int i = 0; i < this._numMetrics; ++i) {
                metrics[i] = this._valueAggregators[i].getInitialAggregatedValue(segmentRecord._metrics[i]);
            }
            return new Record(dimensions, metrics);
        }
        for (int i = 0; i < this._numMetrics; ++i) {
            aggregatedRecord._metrics[i] = this._valueAggregators[i].applyRawValue(aggregatedRecord._metrics[i], segmentRecord._metrics[i]);
        }
        return aggregatedRecord;
    }

    Record mergeStarTreeRecord(@Nullable Record aggregatedRecord, Record starTreeRecord) {
        if (aggregatedRecord == null) {
            int[] dimensions = Arrays.copyOf(starTreeRecord._dimensions, this._numDimensions);
            Object[] metrics = new Object[this._numMetrics];
            for (int i = 0; i < this._numMetrics; ++i) {
                metrics[i] = this._valueAggregators[i].cloneAggregatedValue(starTreeRecord._metrics[i]);
            }
            return new Record(dimensions, metrics);
        }
        for (int i = 0; i < this._numMetrics; ++i) {
            aggregatedRecord._metrics[i] = this._valueAggregators[i].applyAggregatedValue(aggregatedRecord._metrics[i], starTreeRecord._metrics[i]);
        }
        return aggregatedRecord;
    }

    @Override
    public void build() throws Exception {
        long startTime = System.currentTimeMillis();
        LOGGER.info("Start building star-trees with config: {}", (Object)this._builderConfig);
        int numSegmentRecords = this._segment.getSegmentMetadata().getTotalRawDocs();
        Iterator<Record> recordIterator = this.sortAndAggregateSegmentRecords(numSegmentRecords);
        while (recordIterator.hasNext()) {
            this.appendToStarTree(recordIterator.next());
        }
        int numStarTreeRecords = this._numDocs;
        LOGGER.info("Generated {} star-tree records from {} segment records", (Object)numStarTreeRecords, (Object)numSegmentRecords);
        int numRecordsUnderStarNode = this._numDocs - numStarTreeRecords;
        this.constructStarTree(this._rootNode, 0, this._numDocs);
        LOGGER.info("Finish constructing star-tree, got {} tree nodes and {} records under star-node", (Object)this._numNodes, (Object)numRecordsUnderStarNode);
        this.createAggregatedDocs(this._rootNode);
        LOGGER.info("Finish creating aggregated documents, got {} aggregated records", (Object)(this._numDocs - numRecordsUnderStarNode));
        this.createForwardIndexes();
        StarTreeBuilderUtils.serializeTree(new File(this._outputDir, "star_tree.index"), this._rootNode, this._dimensionsSplitOrder, this._numNodes);
        this.writeMetadata();
        LOGGER.info("Finish building star-tree in {}ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void appendToStarTree(Record record) throws IOException {
        this.appendRecord(record);
        ++this._numDocs;
    }

    private StarTreeBuilderUtils.TreeNode getNewNode() {
        ++this._numNodes;
        return new StarTreeBuilderUtils.TreeNode();
    }

    private void constructStarTree(StarTreeBuilderUtils.TreeNode node, int startDocId, int endDocId) throws IOException {
        int childDimensionId = node._dimensionId + 1;
        if (childDimensionId == this._numDimensions) {
            return;
        }
        node._childDimensionId = childDimensionId;
        Map<Integer, StarTreeBuilderUtils.TreeNode> children = this.constructNonStarNodes(startDocId, endDocId, childDimensionId);
        node._children = children;
        if (!this._skipStarNodeCreationForDimensions.contains(childDimensionId) && children.size() > 1) {
            children.put(-1, this.constructStarNode(startDocId, endDocId, childDimensionId));
        }
        for (StarTreeBuilderUtils.TreeNode child : children.values()) {
            if (child._endDocId - child._startDocId <= this._maxLeafRecords) continue;
            this.constructStarTree(child, child._startDocId, child._endDocId);
        }
    }

    private Map<Integer, StarTreeBuilderUtils.TreeNode> constructNonStarNodes(int startDocId, int endDocId, int dimensionId) throws IOException {
        HashMap<Integer, StarTreeBuilderUtils.TreeNode> nodes = new HashMap<Integer, StarTreeBuilderUtils.TreeNode>();
        int nodeStartDocId = startDocId;
        int nodeDimensionValue = this.getDimensionValue(startDocId, dimensionId);
        for (int i = startDocId + 1; i < endDocId; ++i) {
            int dimensionValue = this.getDimensionValue(i, dimensionId);
            if (dimensionValue == nodeDimensionValue) continue;
            StarTreeBuilderUtils.TreeNode child = this.getNewNode();
            child._dimensionId = dimensionId;
            child._dimensionValue = nodeDimensionValue;
            child._startDocId = nodeStartDocId;
            child._endDocId = i;
            nodes.put(nodeDimensionValue, child);
            nodeStartDocId = i;
            nodeDimensionValue = dimensionValue;
        }
        StarTreeBuilderUtils.TreeNode laseNode = this.getNewNode();
        laseNode._dimensionId = dimensionId;
        laseNode._dimensionValue = nodeDimensionValue;
        laseNode._startDocId = nodeStartDocId;
        laseNode._endDocId = endDocId;
        nodes.put(nodeDimensionValue, laseNode);
        return nodes;
    }

    private StarTreeBuilderUtils.TreeNode constructStarNode(int startDocId, int endDocId, int dimensionId) throws IOException {
        StarTreeBuilderUtils.TreeNode starNode = this.getNewNode();
        starNode._dimensionId = dimensionId;
        starNode._dimensionValue = -1;
        starNode._startDocId = this._numDocs;
        Iterator<Record> recordIterator = this.generateRecordsForStarNode(startDocId, endDocId, dimensionId);
        while (recordIterator.hasNext()) {
            this.appendToStarTree(recordIterator.next());
        }
        starNode._endDocId = this._numDocs;
        return starNode;
    }

    private Record createAggregatedDocs(StarTreeBuilderUtils.TreeNode node) throws IOException {
        if (node._children == null) {
            int i;
            Record record = null;
            for (i = node._startDocId; i < node._endDocId; ++i) {
                record = this.mergeStarTreeRecord(record, this.getStarTreeRecord(i));
            }
            assert (record != null);
            for (i = node._dimensionId + 1; i < this._numDimensions; ++i) {
                record._dimensions[i] = 0;
            }
            node._aggregatedDocId = this._numDocs;
            this.appendToStarTree(record);
            return record;
        }
        if (node._children.containsKey(-1)) {
            Record record = null;
            for (StarTreeBuilderUtils.TreeNode child : node._children.values()) {
                if (child._dimensionValue == -1) {
                    record = this.createAggregatedDocs(child);
                    node._aggregatedDocId = child._aggregatedDocId;
                    continue;
                }
                this.createAggregatedDocs(child);
            }
            return record;
        }
        Record record = null;
        for (StarTreeBuilderUtils.TreeNode child : node._children.values()) {
            record = this.mergeStarTreeRecord(record, this.createAggregatedDocs(child));
        }
        assert (record != null);
        for (int i = node._dimensionId + 1; i < this._numDimensions; ++i) {
            record._dimensions[i] = 0;
        }
        node._aggregatedDocId = this._numDocs;
        this.appendToStarTree(record);
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createForwardIndexes() throws Exception {
        SingleValueUnsortedForwardIndexCreator[] dimensionIndexCreators = new SingleValueUnsortedForwardIndexCreator[this._numDimensions];
        for (int i = 0; i < this._numDimensions; ++i) {
            String dimension = this._dimensionsSplitOrder[i];
            int cardinality = this._segment.getDictionary(dimension).length();
            dimensionIndexCreators[i] = new SingleValueUnsortedForwardIndexCreator(this._outputDir, this._dimensionsSplitOrder[i], cardinality, this._numDocs);
        }
        SingleValueRawIndexCreator[] metricIndexCreators = new SingleValueRawIndexCreator[this._numMetrics];
        for (int i = 0; i < this._numMetrics; ++i) {
            String metric = this._metrics[i];
            ValueAggregator valueAggregator = this._valueAggregators[i];
            metricIndexCreators[i] = valueAggregator.getAggregatedValueType() == FieldSpec.DataType.BYTES ? new SingleValueVarByteRawIndexCreator(this._outputDir, .ChunkCompressorFactory.CompressionType.PASS_THROUGH, metric, this._numDocs, valueAggregator.getMaxAggregatedValueByteSize()) : new SingleValueFixedByteRawIndexCreator(this._outputDir, .ChunkCompressorFactory.CompressionType.PASS_THROUGH, metric, this._numDocs, valueAggregator.getMaxAggregatedValueByteSize());
        }
        try {
            for (int docId = 0; docId < this._numDocs; ++docId) {
                int i;
                Record record = this.getStarTreeRecord(docId);
                for (i = 0; i < this._numDimensions; ++i) {
                    dimensionIndexCreators[i].index(docId, record._dimensions[i]);
                }
                for (i = 0; i < this._numMetrics; ++i) {
                    ValueAggregator valueAggregator = this._valueAggregators[i];
                    if (valueAggregator.getAggregatedValueType() == FieldSpec.DataType.BYTES) {
                        metricIndexCreators[i].index(docId, valueAggregator.serializeAggregatedValue(record._metrics[i]));
                        continue;
                    }
                    metricIndexCreators[i].index(docId, record._metrics[i]);
                }
            }
        }
        finally {
            for (SingleValueUnsortedForwardIndexCreator singleValueUnsortedForwardIndexCreator : dimensionIndexCreators) {
                singleValueUnsortedForwardIndexCreator.close();
            }
            for (ForwardIndexCreator forwardIndexCreator : metricIndexCreators) {
                forwardIndexCreator.close();
            }
        }
    }

    private void writeMetadata() {
        this._metadataProperties.setProperty("total.docs", this._numDocs);
        this._metadataProperties.setProperty("split.order", this._dimensionsSplitOrder);
        this._metadataProperties.setProperty("function.column.pairs", this._metrics);
        this._metadataProperties.setProperty("max.leaf.records", this._maxLeafRecords);
        this._metadataProperties.setProperty("skip.star.node.creation", this._builderConfig.getSkipStarNodeCreationForDimensions());
    }

    static class Record {
        final int[] _dimensions;
        final Object[] _metrics;

        Record(int[] dimensions, Object[] metrics) {
            this._dimensions = dimensions;
            this._metrics = metrics;
        }
    }
}

