/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pinot.;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.$internal.org.apache.commons.io.FileUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegmentLoader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.SegmentDirectoryPaths;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder.OffHeapSingleTreeBuilder;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder.OnHeapSingleTreeBuilder;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder.SingleTreeBuilder;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder.StarTreeIndexCombiner;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.store.StarTreeIndexMapUtils;
import org.apache.pinot.common.segment.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleTreesBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipleTreesBuilder.class);
    private final List<StarTreeV2BuilderConfig> _builderConfigs;
    private final ImmutableSegment _segment;
    private final File _segmentDirectory;
    private final PropertiesConfiguration _metadataProperties;
    private final BuildMode _buildMode;

    public MultipleTreesBuilder(List<StarTreeV2BuilderConfig> builderConfigs, File indexDir, BuildMode buildMode) throws Exception {
        this._builderConfigs = builderConfigs;
        this._segmentDirectory = SegmentDirectoryPaths.findSegmentDirectory(indexDir);
        this._segment = ImmutableSegmentLoader.load(indexDir, ReadMode.mmap);
        this._metadataProperties = new PropertiesConfiguration(new File(this._segmentDirectory, "metadata.properties"));
        Preconditions.checkState(!this._metadataProperties.getBoolean("startree.enabled", false), "Star-tree already exists");
        Preconditions.checkState(!this._metadataProperties.containsKey("startree.v2.count"), "Star-tree v2 already exists");
        this._buildMode = buildMode;
    }

    public void build() throws Exception {
        long startTime = System.currentTimeMillis();
        int numStarTrees = this._builderConfigs.size();
        LOGGER.info("Start building {} star-trees with configs: {} using {} builder", new Object[]{numStarTrees, this._builderConfigs, this._buildMode});
        try (StarTreeIndexCombiner indexCombiner = new StarTreeIndexCombiner(new File(this._segmentDirectory, "star_tree_index"));){
            File starTreeIndexDir = new File(this._segmentDirectory, "star_tree_tmp");
            FileUtils.forceMkdir(starTreeIndexDir);
            this._metadataProperties.addProperty("startree.v2.count", numStarTrees);
            ArrayList<Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>> indexMaps = new ArrayList<Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>>(numStarTrees);
            for (int i = 0; i < numStarTrees; ++i) {
                StarTreeV2BuilderConfig builderConfig = this._builderConfigs.get(i);
                Configuration metadataProperties = this._metadataProperties.subset(.StarTreeV2Constants.MetadataKey.getStarTreePrefix(i));
                try (SingleTreeBuilder singleTreeBuilder = MultipleTreesBuilder.getSingleTreeBuilder(builderConfig, starTreeIndexDir, this._segment, metadataProperties, this._buildMode);){
                    singleTreeBuilder.build();
                }
                indexMaps.add(indexCombiner.combine(builderConfig, starTreeIndexDir));
            }
            this._metadataProperties.save();
            StarTreeIndexMapUtils.storeToFile(indexMaps, new File(this._segmentDirectory, "star_tree_index_map"));
            FileUtils.forceDelete(starTreeIndexDir);
        }
        LOGGER.info("Finish building {} star-trees in {}ms", (Object)numStarTrees, (Object)(System.currentTimeMillis() - startTime));
    }

    private static SingleTreeBuilder getSingleTreeBuilder(StarTreeV2BuilderConfig builderConfig, File outputDir, ImmutableSegment segment, Configuration metadataProperties, BuildMode buildMode) throws FileNotFoundException {
        if (buildMode == BuildMode.ON_HEAP) {
            return new OnHeapSingleTreeBuilder(builderConfig, outputDir, segment, metadataProperties);
        }
        return new OffHeapSingleTreeBuilder(builderConfig, outputDir, segment, metadataProperties);
    }

    public static enum BuildMode {
        ON_HEAP,
        OFF_HEAP;

    }
}

