/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder.BaseSingleTreeBuilder;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder.StarTreeV2BuilderConfig;

public class OnHeapSingleTreeBuilder
extends BaseSingleTreeBuilder {
    private List<BaseSingleTreeBuilder.Record> _records = new ArrayList<BaseSingleTreeBuilder.Record>();

    public OnHeapSingleTreeBuilder(StarTreeV2BuilderConfig builderConfig, File outputDir, ImmutableSegment segment, Configuration metadataProperties) {
        super(builderConfig, outputDir, segment, metadataProperties);
    }

    @Override
    void appendRecord(BaseSingleTreeBuilder.Record record) {
        this._records.add(record);
    }

    @Override
    BaseSingleTreeBuilder.Record getStarTreeRecord(int docId) {
        return this._records.get(docId);
    }

    @Override
    int getDimensionValue(int docId, int dimensionId) {
        return this._records.get((int)docId)._dimensions[dimensionId];
    }

    @Override
    Iterator<BaseSingleTreeBuilder.Record> sortAndAggregateSegmentRecords(final int numDocs) {
        final BaseSingleTreeBuilder.Record[] records = new BaseSingleTreeBuilder.Record[numDocs];
        for (int i = 0; i < numDocs; ++i) {
            records[i] = this.getSegmentRecord(i);
        }
        Arrays.sort(records, (o1, o2) -> {
            for (int i = 0; i < this._numDimensions; ++i) {
                if (o1._dimensions[i] == o2._dimensions[i]) continue;
                return o1._dimensions[i] - o2._dimensions[i];
            }
            return 0;
        });
        return new Iterator<BaseSingleTreeBuilder.Record>(){
            boolean _hasNext = true;
            BaseSingleTreeBuilder.Record _currentRecord = records[0];
            int _docId = 1;

            @Override
            public boolean hasNext() {
                return this._hasNext;
            }

            @Override
            public BaseSingleTreeBuilder.Record next() {
                BaseSingleTreeBuilder.Record next = OnHeapSingleTreeBuilder.this.mergeSegmentRecord(null, this._currentRecord);
                while (this._docId < numDocs) {
                    BaseSingleTreeBuilder.Record record = records[this._docId++];
                    if (!Arrays.equals(record._dimensions, next._dimensions)) {
                        this._currentRecord = record;
                        return next;
                    }
                    next = OnHeapSingleTreeBuilder.this.mergeSegmentRecord(next, record);
                }
                this._hasNext = false;
                return next;
            }
        };
    }

    @Override
    Iterator<BaseSingleTreeBuilder.Record> generateRecordsForStarNode(int startDocId, int endDocId, final int dimensionId) {
        final int numDocs = endDocId - startDocId;
        final BaseSingleTreeBuilder.Record[] records = new BaseSingleTreeBuilder.Record[numDocs];
        for (int i = 0; i < numDocs; ++i) {
            records[i] = this.getStarTreeRecord(startDocId + i);
        }
        Arrays.sort(records, (o1, o2) -> {
            for (int i = dimensionId + 1; i < this._numDimensions; ++i) {
                if (o1._dimensions[i] == o2._dimensions[i]) continue;
                return o1._dimensions[i] - o2._dimensions[i];
            }
            return 0;
        });
        return new Iterator<BaseSingleTreeBuilder.Record>(){
            boolean _hasNext = true;
            BaseSingleTreeBuilder.Record _currentRecord = records[0];
            int _docId = 1;

            private boolean hasSameDimensions(BaseSingleTreeBuilder.Record record1, BaseSingleTreeBuilder.Record record2) {
                for (int i = dimensionId + 1; i < OnHeapSingleTreeBuilder.this._numDimensions; ++i) {
                    if (record1._dimensions[i] == record2._dimensions[i]) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                return this._hasNext;
            }

            @Override
            public BaseSingleTreeBuilder.Record next() {
                BaseSingleTreeBuilder.Record next = OnHeapSingleTreeBuilder.this.mergeStarTreeRecord(null, this._currentRecord);
                next._dimensions[dimensionId] = 0;
                while (this._docId < numDocs) {
                    BaseSingleTreeBuilder.Record record;
                    if (!this.hasSameDimensions(record = records[this._docId++], this._currentRecord)) {
                        this._currentRecord = record;
                        return next;
                    }
                    next = OnHeapSingleTreeBuilder.this.mergeStarTreeRecord(next, record);
                }
                this._hasNext = false;
                return next;
            }
        };
    }

    @Override
    public void close() {
    }
}

