/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pinot.$internal.org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.pinot.$internal.org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;
import org.apache.pinot.common.config.StarTreeIndexConfig;

public class StarTreeV2BuilderConfig {
    public static final int DEFAULT_MAX_LEAF_RECORDS = 10000;
    private final List<String> _dimensionsSplitOrder;
    private final Set<String> _skipStarNodeCreationForDimensions;
    private final Set<AggregationFunctionColumnPair> _functionColumnPairs;
    private final int _maxLeafRecords;

    public static StarTreeV2BuilderConfig fromIndexConfig(StarTreeIndexConfig indexConfig) {
        Builder builder = new Builder();
        builder.setDimensionsSplitOrder(indexConfig.getDimensionsSplitOrder());
        List<String> skipStarNodeCreationForDimensions = indexConfig.getSkipStarNodeCreationForDimensions();
        if (skipStarNodeCreationForDimensions != null && !skipStarNodeCreationForDimensions.isEmpty()) {
            builder.setSkipStarNodeCreationForDimensions(new HashSet<String>(skipStarNodeCreationForDimensions));
        }
        HashSet<AggregationFunctionColumnPair> functionColumnPairs = new HashSet<AggregationFunctionColumnPair>();
        for (String functionColumnPair : indexConfig.getFunctionColumnPairs()) {
            functionColumnPairs.add(AggregationFunctionColumnPair.fromColumnName(functionColumnPair));
        }
        builder.setFunctionColumnPairs(functionColumnPairs);
        int maxLeafRecords = indexConfig.getMaxLeafRecords();
        if (maxLeafRecords > 0) {
            builder.setMaxLeafRecords(maxLeafRecords);
        }
        return builder.build();
    }

    private StarTreeV2BuilderConfig(List<String> dimensionsSplitOrder, Set<String> skipStarNodeCreationForDimensions, Set<AggregationFunctionColumnPair> functionColumnPairs, int maxLeafRecords) {
        this._dimensionsSplitOrder = dimensionsSplitOrder;
        this._skipStarNodeCreationForDimensions = skipStarNodeCreationForDimensions;
        this._functionColumnPairs = functionColumnPairs;
        this._maxLeafRecords = maxLeafRecords;
    }

    public List<String> getDimensionsSplitOrder() {
        return this._dimensionsSplitOrder;
    }

    public Set<String> getSkipStarNodeCreationForDimensions() {
        return this._skipStarNodeCreationForDimensions;
    }

    public Set<AggregationFunctionColumnPair> getFunctionColumnPairs() {
        return this._functionColumnPairs;
    }

    public int getMaxLeafRecords() {
        return this._maxLeafRecords;
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("splitOrder", this._dimensionsSplitOrder).append("skipStarNodeCreation", this._skipStarNodeCreationForDimensions).append("functionColumnPairs", this._functionColumnPairs).append("maxLeafRecords", this._maxLeafRecords).toString();
    }

    public static class Builder {
        private List<String> _dimensionsSplitOrder;
        private Set<String> _skipStarNodeCreationForDimensions;
        private Set<AggregationFunctionColumnPair> _functionColumnPairs;
        private int _maxLeafRecords = 10000;

        public Builder setDimensionsSplitOrder(List<String> dimensionsSplitOrder) {
            this._dimensionsSplitOrder = dimensionsSplitOrder;
            return this;
        }

        public Builder setSkipStarNodeCreationForDimensions(Set<String> skipStarNodeCreationForDimensions) {
            this._skipStarNodeCreationForDimensions = skipStarNodeCreationForDimensions;
            return this;
        }

        public Builder setFunctionColumnPairs(Set<AggregationFunctionColumnPair> functionColumnPairs) {
            this._functionColumnPairs = functionColumnPairs;
            return this;
        }

        public Builder setMaxLeafRecords(int maxLeafRecords) {
            this._maxLeafRecords = maxLeafRecords;
            return this;
        }

        public StarTreeV2BuilderConfig build() {
            if (this._dimensionsSplitOrder == null || this._dimensionsSplitOrder.isEmpty()) {
                throw new IllegalStateException("Illegal dimensions split order: " + this._dimensionsSplitOrder);
            }
            if (this._skipStarNodeCreationForDimensions == null) {
                this._skipStarNodeCreationForDimensions = Collections.emptySet();
            }
            if (!this._dimensionsSplitOrder.containsAll(this._skipStarNodeCreationForDimensions)) {
                throw new IllegalStateException("Can not skip star-node creation for dimension not in the split order, dimensionsSplitOrder: " + this._dimensionsSplitOrder + ", skipStarNodeCreationForDimensions: " + this._skipStarNodeCreationForDimensions);
            }
            if (this._functionColumnPairs == null || this._functionColumnPairs.isEmpty()) {
                throw new IllegalStateException("Illegal function-column pairs: " + this._functionColumnPairs);
            }
            if (this._maxLeafRecords <= 0) {
                throw new IllegalStateException("Illegal maximum number of leaf records: " + this._maxLeafRecords);
            }
            return new StarTreeV2BuilderConfig(this._dimensionsSplitOrder, this._skipStarNodeCreationForDimensions, this._functionColumnPairs, this._maxLeafRecords);
        }
    }
}

