/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.store;

import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Block;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.FixedBitSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.SingleValueBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.common.data.FieldSpec;

public class StarTreeDimensionDataSource
extends DataSource {
    private final int _numDocs;
    private final FieldSpec.DataType _dataType;
    private final Dictionary _dictionary;
    private final FixedBitSingleValueReader _forwardIndex;
    private final DataSourceMetadata _metadata;
    private final String _operatorName;

    public StarTreeDimensionDataSource(PinotDataBuffer dataBuffer, String dimension, int numDocs, FieldSpec.DataType dataType, Dictionary dictionary, int numBitsPerValue, final int cardinality) {
        this._numDocs = numDocs;
        this._dataType = dataType;
        this._dictionary = dictionary;
        this._forwardIndex = new FixedBitSingleValueReader(dataBuffer, numDocs, numBitsPerValue);
        this._metadata = new DataSourceMetadata(){

            @Override
            public FieldSpec.DataType getDataType() {
                return StarTreeDimensionDataSource.this._dataType;
            }

            @Override
            public boolean isSingleValue() {
                return true;
            }

            @Override
            public boolean isSorted() {
                return false;
            }

            @Override
            public int getNumDocs() {
                return StarTreeDimensionDataSource.this._numDocs;
            }

            @Override
            public int getMaxNumMultiValues() {
                return 0;
            }

            @Override
            public boolean hasInvertedIndex() {
                return false;
            }

            @Override
            public boolean hasDictionary() {
                return true;
            }

            @Override
            public int getCardinality() {
                return cardinality;
            }
        };
        this._operatorName = "StarTreeDimensionDataSource [" + dimension + "]";
    }

    @Override
    public DataSourceMetadata getDataSourceMetadata() {
        return this._metadata;
    }

    @Override
    public .InvertedIndexReader getInvertedIndex() {
        return null;
    }

    @Override
    public .BloomFilterReader getBloomFilter() {
        return null;
    }

    @Override
    public Dictionary getDictionary() {
        return this._dictionary;
    }

    protected Block getNextBlock() {
        return new SingleValueBlock(this._forwardIndex, this._numDocs, this._dataType, this._dictionary);
    }

    @Override
    public String getOperatorName() {
        return this._operatorName;
    }
}

