/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.store;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.configuration.ConfigurationException;
import org.apache.pinot.$internal.org.apache.commons.configuration.PropertiesConfiguration;

public class StarTreeIndexMapUtils {
    public static final IndexKey STAR_TREE_INDEX_KEY = new IndexKey(IndexType.STAR_TREE, null);
    private static final String OFFSET_SUFFIX = "OFFSET";
    private static final String SIZE_SUFFIX = "SIZE";

    private StarTreeIndexMapUtils() {
    }

    public static void storeToFile(List<Map<IndexKey, IndexValue>> indexMaps, File indexMapFile) throws ConfigurationException {
        Preconditions.checkState(!indexMapFile.exists(), "Star-tree index map file already exists");
        PropertiesConfiguration configuration = new PropertiesConfiguration(indexMapFile);
        int numStarTrees = indexMaps.size();
        for (int i = 0; i < numStarTrees; ++i) {
            Map<IndexKey, IndexValue> indexMap = indexMaps.get(i);
            for (Map.Entry<IndexKey, IndexValue> entry : indexMap.entrySet()) {
                IndexKey key = entry.getKey();
                IndexValue value = entry.getValue();
                configuration.addProperty(key.getPropertyName(i, OFFSET_SUFFIX), value._offset);
                configuration.addProperty(key.getPropertyName(i, SIZE_SUFFIX), value._size);
            }
        }
        configuration.save();
    }

    public static List<Map<IndexKey, IndexValue>> loadFromFile(File indexMapFile, int numStarTrees) throws ConfigurationException {
        Preconditions.checkState(indexMapFile.exists(), "Star-tree index map file does not exist");
        PropertiesConfiguration configuration = new PropertiesConfiguration(indexMapFile);
        ArrayList<Map<IndexKey, IndexValue>> indexMaps = new ArrayList<Map<IndexKey, IndexValue>>(numStarTrees);
        for (int i = 0; i < numStarTrees; ++i) {
            indexMaps.add(new HashMap());
        }
        Iterator keys = configuration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String[] split = key.split("\\.");
            Preconditions.checkState(split.length == 4, "Invalid key: " + key + " in star-tree index map file: " + indexMapFile.getAbsolutePath());
            int starTreeId = Integer.parseInt(split[0]);
            Map indexMap = (Map)indexMaps.get(starTreeId);
            IndexType indexType = IndexType.valueOf(split[2]);
            IndexKey indexKey = indexType == IndexType.STAR_TREE ? STAR_TREE_INDEX_KEY : new IndexKey(IndexType.FORWARD_INDEX, split[1]);
            IndexValue indexValue = indexMap.computeIfAbsent(indexKey, k -> new IndexValue());
            long value = configuration.getLong(key);
            if (split[3].equals(OFFSET_SUFFIX)) {
                indexValue._offset = value;
                continue;
            }
            indexValue._size = value;
        }
        return indexMaps;
    }

    public static class IndexValue
    implements Comparable<IndexValue> {
        public long _offset;
        public long _size;

        public IndexValue() {
        }

        public IndexValue(long offset, long size) {
            this._offset = offset;
            this._size = size;
        }

        @Override
        public int compareTo(@Nonnull IndexValue o) {
            return Long.compare(this._offset, o._offset);
        }
    }

    public static class IndexKey {
        public final IndexType _indexType;
        public final String _column;

        public IndexKey(IndexType indexType, @Nullable String column) {
            this._indexType = indexType;
            this._column = column;
        }

        public String getPropertyName(int starTreeId, String suffix) {
            return String.format("%d.%s.%s.%s", new Object[]{starTreeId, this._column, this._indexType, suffix});
        }

        public int hashCode() {
            return 31 * this._indexType.hashCode() + Objects.hashCode(this._column);
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof IndexKey) {
                IndexKey that = (IndexKey)obj;
                return this._indexType == that._indexType && Objects.equals(this._column, that._column);
            }
            return false;
        }
    }

    public static enum IndexType {
        STAR_TREE,
        FORWARD_INDEX;

    }
}

