/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.store;

import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Block;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.BaseChunkSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.FixedByteChunkSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.VarByteChunkSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.SingleValueBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.common.data.FieldSpec;

public class StarTreeMetricDataSource
extends DataSource {
    private final int _numDocs;
    private final FieldSpec.DataType _dataType;
    private final BaseChunkSingleValueReader _forwardIndex;
    private final DataSourceMetadata _metadata;
    private final String _operatorName;

    public StarTreeMetricDataSource(PinotDataBuffer dataBuffer, String metric, int numDocs, FieldSpec.DataType dataType) {
        this._numDocs = numDocs;
        this._dataType = dataType;
        this._forwardIndex = dataType == FieldSpec.DataType.BYTES ? new VarByteChunkSingleValueReader(dataBuffer) : new FixedByteChunkSingleValueReader(dataBuffer);
        this._metadata = new DataSourceMetadata(){

            @Override
            public FieldSpec.DataType getDataType() {
                return StarTreeMetricDataSource.this._dataType;
            }

            @Override
            public boolean isSingleValue() {
                return true;
            }

            @Override
            public boolean isSorted() {
                return false;
            }

            @Override
            public int getNumDocs() {
                return StarTreeMetricDataSource.this._numDocs;
            }

            @Override
            public int getMaxNumMultiValues() {
                return 0;
            }

            @Override
            public boolean hasInvertedIndex() {
                return false;
            }

            @Override
            public boolean hasDictionary() {
                return false;
            }

            @Override
            public int getCardinality() {
                return Integer.MIN_VALUE;
            }
        };
        this._operatorName = "StarTreeMetricDataSource [" + metric + "]";
    }

    @Override
    public DataSourceMetadata getDataSourceMetadata() {
        return this._metadata;
    }

    @Override
    public .InvertedIndexReader getInvertedIndex() {
        return null;
    }

    @Override
    public Dictionary getDictionary() {
        return null;
    }

    @Override
    public .BloomFilterReader getBloomFilter() {
        return null;
    }

    protected Block getNextBlock() {
        return new SingleValueBlock(this._forwardIndex, this._numDocs, this._dataType, null);
    }

    @Override
    public String getOperatorName() {
        return this._operatorName;
    }
}

