/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.transport;

import org.apache.pinot.$internal.io.netty.buffer.ByteBuf;
import org.apache.pinot.$internal.io.netty.channel.ChannelHandlerContext;
import org.apache.pinot.$internal.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.pinot.$internal.org.apache.pinot.core.common.datatable.DataTableFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.transport.QueryRouter;
import org.apache.pinot.$internal.org.apache.pinot.core.transport.Server;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.utils.DataTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTableHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTableHandler.class);
    private final QueryRouter _queryRouter;
    private final Server _server;
    private final BrokerMetrics _brokerMetrics;

    public DataTableHandler(QueryRouter queryRouter, Server server, BrokerMetrics brokerMetrics) {
        this._queryRouter = queryRouter;
        this._server = server;
        this._brokerMetrics = brokerMetrics;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        LOGGER.info("Channel for server: {} is now active", (Object)this._server);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        LOGGER.error("Channel for server: {} is now inactive, marking server down", (Object)this._server);
        this._queryRouter.markServerDown(this._server);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
        long responseSize = msg.readableBytes();
        this._brokerMetrics.addMeteredGlobalValue(BrokerMeter.NETTY_CONNECTION_BYTES_RECEIVED, responseSize);
        try {
            long deserializationStartTimeMs = System.currentTimeMillis();
            DataTable dataTable = DataTableFactory.getDataTable(msg.nioBuffer());
            this._queryRouter.receiveDataTable(this._server, dataTable, responseSize, System.currentTimeMillis() - deserializationStartTimeMs);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while deserializing data table of size: {} from server: {}", new Object[]{responseSize, this._server, e});
            this._brokerMetrics.addMeteredGlobalValue(BrokerMeter.DATA_TABLE_DESERIALIZATION_EXCEPTIONS, 1L);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.error("Caught exception while handling response from server: {}", (Object)this._server, (Object)cause);
        this._brokerMetrics.addMeteredGlobalValue(BrokerMeter.RESPONSE_FETCH_EXCEPTIONS, 1L);
    }
}

