/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.transport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.$internal.org.apache.pinot.core.transport.AsyncQueryResponse;
import org.apache.pinot.$internal.org.apache.pinot.core.transport.Server;
import org.apache.pinot.$internal.org.apache.pinot.core.transport.ServerChannels;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.InstanceRequest;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.common.utils.DataTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class QueryRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryRouter.class);
    private final String _brokerId;
    private final BrokerMetrics _brokerMetrics;
    private final ServerChannels _serverChannels;
    private final ConcurrentHashMap<Long, AsyncQueryResponse> _asyncQueryResponseMap = new ConcurrentHashMap();

    public QueryRouter(String brokerId, BrokerMetrics brokerMetrics) {
        this._brokerId = brokerId;
        this._brokerMetrics = brokerMetrics;
        this._serverChannels = new ServerChannels(this, brokerMetrics);
    }

    public AsyncQueryResponse submitQuery(long requestId, String rawTableName, @Nullable BrokerRequest offlineBrokerRequest, @Nullable Map<String, List<String>> offlineRoutingTable, @Nullable BrokerRequest realtimeBrokerRequest, @Nullable Map<String, List<String>> realtimeRoutingTable, long timeoutMs) {
        InstanceRequest instanceRequest;
        Server server;
        assert (offlineBrokerRequest != null || realtimeBrokerRequest != null);
        HashMap<Server, InstanceRequest> requestMap = new HashMap<Server, InstanceRequest>();
        if (offlineBrokerRequest != null) {
            assert (offlineRoutingTable != null);
            for (Map.Entry<String, List<String>> entry : offlineRoutingTable.entrySet()) {
                server = new Server(entry.getKey(), CommonConstants.Helix.TableType.OFFLINE);
                instanceRequest = this.getInstanceRequest(requestId, offlineBrokerRequest, entry.getValue());
                requestMap.put(server, instanceRequest);
            }
        }
        if (realtimeBrokerRequest != null) {
            assert (realtimeRoutingTable != null);
            for (Map.Entry<String, List<String>> entry : realtimeRoutingTable.entrySet()) {
                server = new Server(entry.getKey(), CommonConstants.Helix.TableType.REALTIME);
                instanceRequest = this.getInstanceRequest(requestId, realtimeBrokerRequest, entry.getValue());
                requestMap.put(server, instanceRequest);
            }
        }
        AsyncQueryResponse asyncQueryResponse = new AsyncQueryResponse(this, requestId, requestMap.keySet(), System.currentTimeMillis(), timeoutMs);
        this._asyncQueryResponseMap.put(requestId, asyncQueryResponse);
        for (Map.Entry entry : requestMap.entrySet()) {
            Server server2 = (Server)entry.getKey();
            try {
                this._serverChannels.sendRequest(server2, (InstanceRequest)entry.getValue());
                asyncQueryResponse.markRequestSubmitted(server2);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while sending request {} to server: {}, marking query failed", new Object[]{requestId, server2, e});
                this._brokerMetrics.addMeteredTableValue(rawTableName, BrokerMeter.REQUEST_SEND_EXCEPTIONS, 1L);
                asyncQueryResponse.markQueryFailed();
                break;
            }
        }
        return asyncQueryResponse;
    }

    public void shutDown() {
        this._serverChannels.shutDown();
    }

    void receiveDataTable(Server server, DataTable dataTable, long responseSize, long deserializationTimeMs) {
        long requestId = Long.parseLong(dataTable.getMetadata().get("requestId"));
        AsyncQueryResponse asyncQueryResponse = this._asyncQueryResponseMap.get(requestId);
        if (asyncQueryResponse != null) {
            asyncQueryResponse.receiveDataTable(server, dataTable, responseSize, deserializationTimeMs);
        }
    }

    void markServerDown(Server server) {
        for (AsyncQueryResponse asyncQueryResponse : this._asyncQueryResponseMap.values()) {
            asyncQueryResponse.markServerDown(server);
        }
    }

    void markQueryDone(long requestId) {
        this._asyncQueryResponseMap.remove(requestId);
    }

    private InstanceRequest getInstanceRequest(long requestId, BrokerRequest brokerRequest, List<String> segments) {
        InstanceRequest instanceRequest = new InstanceRequest();
        instanceRequest.setRequestId(requestId);
        instanceRequest.setQuery(brokerRequest);
        instanceRequest.setEnableTrace(brokerRequest.isEnableTrace());
        instanceRequest.setSearchSegments(segments);
        instanceRequest.setBrokerId(this._brokerId);
        return instanceRequest;
    }
}

