/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.transport;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.$internal.com.google.common.net.InternetDomainName;
import org.apache.pinot.common.utils.CommonConstants;

@ThreadSafe
public class Server {
    private static final String NAME_PORT_DELIMITER = "_";
    private static final String SHORT_OFFLINE_SUFFIX = "_O";
    private static final String SHORT_REALTIME_SUFFIX = "_R";
    private final String _hostName;
    private final int _port;
    private final CommonConstants.Helix.TableType _tableType;
    private transient String _shortName;

    public Server(String instanceName, CommonConstants.Helix.TableType tableType) {
        String[] hostNameAndPort = instanceName.split("Server_")[1].split(NAME_PORT_DELIMITER);
        this._hostName = hostNameAndPort[0];
        this._port = Integer.parseInt(hostNameAndPort[1]);
        this._tableType = tableType;
    }

    public String getHostName() {
        return this._hostName;
    }

    public int getPort() {
        return this._port;
    }

    public CommonConstants.Helix.TableType getTableType() {
        return this._tableType;
    }

    public synchronized String getShortName() {
        if (this._shortName == null) {
            String shortHostName;
            try {
                InternetDomainName domainName = InternetDomainName.from(this._hostName);
                shortHostName = (String)domainName.parts().get(0);
            }
            catch (Exception e) {
                shortHostName = this._hostName;
            }
            this._shortName = this._tableType == CommonConstants.Helix.TableType.OFFLINE ? shortHostName + SHORT_OFFLINE_SUFFIX : shortHostName + SHORT_REALTIME_SUFFIX;
        }
        return this._shortName;
    }

    public int hashCode() {
        return 961 * this._hostName.hashCode() + 31 * this._port + this._tableType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Server) {
            Server that = (Server)obj;
            return this._hostName.equals(that._hostName) && this._port == that._port && this._tableType == that._tableType;
        }
        return false;
    }

    public String toString() {
        return String.format("%s:%s_%s", new Object[]{this._hostName, this._port, this._tableType});
    }
}

