/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.transport;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.$internal.io.netty.bootstrap.Bootstrap;
import org.apache.pinot.$internal.io.netty.channel.Channel;
import org.apache.pinot.$internal.io.netty.channel.ChannelInitializer;
import org.apache.pinot.$internal.io.netty.channel.ChannelOption;
import org.apache.pinot.$internal.io.netty.channel.EventLoopGroup;
import org.apache.pinot.$internal.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.pinot.$internal.io.netty.channel.socket.SocketChannel;
import org.apache.pinot.$internal.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.pinot.$internal.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.pinot.$internal.io.netty.handler.codec.LengthFieldPrepender;
import org.apache.pinot.$internal.org.apache.pinot.core.transport.DataTableHandler;
import org.apache.pinot.$internal.org.apache.pinot.core.transport.QueryRouter;
import org.apache.pinot.$internal.org.apache.pinot.core.transport.Server;
import org.apache.pinot.$internal.org.apache.thrift.TSerializer;
import org.apache.pinot.$internal.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.pinot.common.metrics.BrokerGauge;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.InstanceRequest;

@ThreadSafe
public class ServerChannels {
    private final QueryRouter _queryRouter;
    private final BrokerMetrics _brokerMetrics;
    private final ConcurrentHashMap<Server, ServerChannel> _serverToChannelMap = new ConcurrentHashMap();
    private final EventLoopGroup _eventLoopGroup = new NioEventLoopGroup();

    public ServerChannels(QueryRouter queryRouter, BrokerMetrics brokerMetrics) {
        this._queryRouter = queryRouter;
        this._brokerMetrics = brokerMetrics;
    }

    public void sendRequest(Server server, InstanceRequest instanceRequest) throws Exception {
        this._serverToChannelMap.computeIfAbsent(server, x$0 -> new ServerChannel((Server)x$0)).sendRequest(instanceRequest);
    }

    public void shutDown() {
        this._eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
    }

    @ThreadSafe
    private class ServerChannel {
        final TSerializer _serializer = new TSerializer(new TCompactProtocol.Factory());
        final Server _server;
        final Bootstrap _bootstrap;
        Channel _channel;

        ServerChannel(Server server) {
            this._server = server;
            this._bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().remoteAddress(server.getHostName(), server.getPort()).group(ServerChannels.this._eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, true)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast(new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4), new LengthFieldPrepender(4), new DataTableHandler(ServerChannels.this._queryRouter, ServerChannel.this._server, ServerChannels.this._brokerMetrics));
                }
            });
        }

        synchronized void sendRequest(InstanceRequest instanceRequest) throws Exception {
            if (this._channel == null || !this._channel.isActive()) {
                long startTime = System.currentTimeMillis();
                this._channel = this._bootstrap.connect().sync().channel();
                ServerChannels.this._brokerMetrics.setValueOfGlobalGauge(BrokerGauge.NETTY_CONNECTION_CONNECT_TIME_MS, System.currentTimeMillis() - startTime);
            }
            byte[] requestBytes = this._serializer.serialize(instanceRequest);
            this._channel.writeAndFlush(this._channel.alloc().buffer(requestBytes.length).writeBytes(requestBytes), this._channel.voidPromise());
            ServerChannels.this._brokerMetrics.addMeteredGlobalValue(BrokerMeter.NETTY_CONNECTION_REQUESTS_SENT, 1L);
            ServerChannels.this._brokerMetrics.addMeteredGlobalValue(BrokerMeter.NETTY_CONNECTION_BYTES_SENT, requestBytes.length);
        }
    }
}

