/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.transport;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.utils.DataTable;

@ThreadSafe
public class ServerResponse {
    private final long _startTimeMs;
    private volatile long _submitRequestTimeMs;
    private volatile long _receiveDataTabTimeMs;
    private volatile DataTable _dataTable;
    private volatile long _responseSize;
    private volatile long _deserializationTimeMs;

    public ServerResponse(long startTimeMs) {
        this._startTimeMs = startTimeMs;
    }

    public DataTable getDataTable() {
        return this._dataTable;
    }

    public long getSubmitDelayMs() {
        if (this._submitRequestTimeMs != 0L) {
            return this._submitRequestTimeMs - this._startTimeMs;
        }
        return -1L;
    }

    public long getResponseDelayMs() {
        if (this._receiveDataTabTimeMs != 0L) {
            return this._receiveDataTabTimeMs - this._submitRequestTimeMs;
        }
        return -1L;
    }

    public long getResponseSize() {
        return this._responseSize;
    }

    public long getDeserializationTimeMs() {
        return this._deserializationTimeMs;
    }

    public String toString() {
        return String.format("%d,%d,%d,%d", this.getSubmitDelayMs(), this.getResponseDelayMs(), this.getResponseSize(), this.getDeserializationTimeMs());
    }

    void markRequestSubmitted() {
        this._submitRequestTimeMs = System.currentTimeMillis();
    }

    void receiveDataTable(DataTable dataTable, long responseSize, long deserializationTimeMs) {
        this._receiveDataTabTimeMs = System.currentTimeMillis();
        this._dataTable = dataTable;
        this._responseSize = responseSize;
        this._deserializationTimeMs = deserializationTimeMs;
    }
}

