/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pinot.$internal.org.apache.pinot.core.util.BaseIndexedPriorityQueue;
import org.apache.pinot.common.utils.Pairs;

@NotThreadSafe
public class IntObjectIndexedPriorityQueue<T extends Comparable>
extends BaseIndexedPriorityQueue {
    ObjectArrayList<T> _values;
    Pairs.IntObjectPair<T> _reusablePair;

    public IntObjectIndexedPriorityQueue(int initialCapacity, boolean minHeap) {
        super(initialCapacity, minHeap);
        this._values = new ObjectArrayList(initialCapacity);
        this._reusablePair = new Pairs.IntObjectPair<Object>(0, null);
    }

    public void put(int key, T value) {
        if (!this._keyToIndexMap.containsKey(key)) {
            this._values.add(value);
            int last = this._values.size() - 1;
            this.updateKeyIndexMap(key, last);
            this.siftUp(last);
        } else {
            int index = this._keyToIndexMap.get(key);
            this._values.set(index, value);
            if (!this.siftDown(index)) {
                this.siftUp(index);
            }
        }
    }

    public Pairs.IntObjectPair get(int key) {
        if (!this._keyToIndexMap.containsKey(key)) {
            return null;
        }
        int index = this._keyToIndexMap.get(key);
        Comparable value = (Comparable)this._values.get(index);
        this._reusablePair.setIntValue(index);
        this._reusablePair.setObjectValue(value);
        return this._reusablePair;
    }

    public Pairs.IntObjectPair<T> poll() {
        if (this.isEmpty()) {
            throw new RuntimeException("Empty collection, nothing to remove");
        }
        Pairs.IntObjectPair<T> poll = this.peek();
        int lastIndex = this._values.size() - 1;
        this.swapValues(0, lastIndex);
        this._values.remove(lastIndex);
        this._keyToIndexMap.remove(this._indexToKeyMap.get(lastIndex));
        this._indexToKeyMap.remove(lastIndex);
        if (!this._values.isEmpty()) {
            this.siftDown(0);
        }
        return poll;
    }

    public Pairs.IntObjectPair<T> peek() {
        if (this._values.isEmpty()) {
            return null;
        }
        this._reusablePair.setIntValue(this._indexToKeyMap.get(0));
        this._reusablePair.setObjectValue((Comparable)this._values.get(0));
        return this._reusablePair;
    }

    public boolean isEmpty() {
        return this._values.isEmpty();
    }

    private void siftUp(int index) {
        if (index == 0) {
            return;
        }
        while (index != 0) {
            int parentIndex = this.getParentIndex(index);
            Comparable value = (Comparable)this._values.get(index);
            Comparable parentValue = (Comparable)this._values.get(parentIndex);
            if (this.compare(parentValue, value) != 1) break;
            this.swapValues(index, parentIndex);
            index = parentIndex;
        }
    }

    private boolean siftDown(int index) {
        boolean hasChildren = this.hasChildren(index);
        if (!hasChildren) {
            return false;
        }
        boolean sifted = false;
        while (true) {
            Comparable rightChildValue;
            Comparable leftChildValue;
            int leftChildIndex = this.getLeftChildIndex(index);
            int rightChildIndex = this.getRightChildIndex(index);
            int size = this._values.size();
            if (leftChildIndex >= size && rightChildIndex >= size) break;
            int minIndex = rightChildIndex >= size ? leftChildIndex : (this.compare(leftChildValue = (Comparable)this._values.get(leftChildIndex), rightChildValue = (Comparable)this._values.get(rightChildIndex)) <= 0 ? leftChildIndex : rightChildIndex);
            if (this.compare((Comparable)this._values.get(index), (Comparable)this._values.get(minIndex)) != 1) break;
            this.swapValues(index, minIndex);
            index = minIndex;
            sifted = true;
        }
        return sifted;
    }

    private int compare(T o1, T o2) {
        int ret = o1.compareTo(o2);
        return this._minHeap ? ret : -ret;
    }

    private void swapValues(int index1, int index2) {
        if (index1 == index2) {
            return;
        }
        Collections.swap(this._values, index1, index2);
        this.swapKeys(index1, index2);
    }

    private boolean hasChildren(int index) {
        return this.getLeftChildIndex(index) < this._values.size();
    }
}

