/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.pql.parsers;

import java.util.Stack;
import org.apache.pinot.$internal.org.antlr.v4.runtime.misc.NotNull;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.PQL2BaseListener;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.PQL2Parser;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.BetweenPredicateAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.BinaryMathOpAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.BooleanOperatorAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.ComparisonPredicateAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.ExpressionParenthesisGroupAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.FloatingPointLiteralAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.GroupByAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.HavingAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.InPredicateAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.IntegerLiteralAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.IsPredicateAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.LimitAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.OptionAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.OptionsAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.OrderByAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.OrderByExpressionAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.OutputColumnAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.OutputColumnListAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.PredicateListAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.PredicateParenthesisGroupAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.RegexpLikePredicateAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.SelectAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.StarColumnListAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.StarExpressionAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.StringLiteralAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.TableNameAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.TopAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.WhereAstNode;

public class Pql2AstListener
extends PQL2BaseListener {
    Stack<AstNode> _nodeStack = new Stack();
    AstNode _rootNode = null;
    private String _expression;

    public Pql2AstListener(String expression) {
        this._expression = expression;
    }

    private void pushNode(AstNode node) {
        if (this._rootNode == null) {
            this._rootNode = node;
        }
        AstNode parentNode = null;
        if (!this._nodeStack.isEmpty()) {
            parentNode = this._nodeStack.peek();
        }
        if (parentNode != null) {
            parentNode.addChild(node);
        }
        node.setParent(parentNode);
        this._nodeStack.push(node);
    }

    private void popNode() {
        AstNode topNode = this._nodeStack.pop();
        topNode.doneProcessingChildren();
    }

    public AstNode getRootNode() {
        return this._rootNode;
    }

    @Override
    public void enterSelect(@NotNull PQL2Parser.SelectContext ctx) {
        this.pushNode(new SelectAstNode());
    }

    @Override
    public void exitSelect(@NotNull PQL2Parser.SelectContext ctx) {
        this.popNode();
    }

    @Override
    public void enterTableName(@NotNull PQL2Parser.TableNameContext ctx) {
        this.pushNode(new TableNameAstNode(ctx.getText()));
    }

    @Override
    public void exitTableName(@NotNull PQL2Parser.TableNameContext ctx) {
        this.popNode();
    }

    @Override
    public void enterStarColumnList(@NotNull PQL2Parser.StarColumnListContext ctx) {
        this.pushNode(new StarColumnListAstNode());
    }

    @Override
    public void exitStarColumnList(@NotNull PQL2Parser.StarColumnListContext ctx) {
        this.popNode();
    }

    @Override
    public void enterOutputColumnList(@NotNull PQL2Parser.OutputColumnListContext ctx) {
        this.pushNode(new OutputColumnListAstNode());
    }

    @Override
    public void exitOutputColumnList(@NotNull PQL2Parser.OutputColumnListContext ctx) {
        this.popNode();
    }

    @Override
    public void enterIsPredicate(@NotNull PQL2Parser.IsPredicateContext ctx) {
        this.pushNode(new IsPredicateAstNode());
    }

    @Override
    public void exitIsPredicate(@NotNull PQL2Parser.IsPredicateContext ctx) {
        this.popNode();
    }

    @Override
    public void enterPredicateParenthesisGroup(@NotNull PQL2Parser.PredicateParenthesisGroupContext ctx) {
        this.pushNode(new PredicateParenthesisGroupAstNode());
    }

    @Override
    public void exitPredicateParenthesisGroup(@NotNull PQL2Parser.PredicateParenthesisGroupContext ctx) {
        this.popNode();
    }

    @Override
    public void enterComparisonPredicate(@NotNull PQL2Parser.ComparisonPredicateContext ctx) {
        this.pushNode(new ComparisonPredicateAstNode(ctx.getChild(0).getChild(1).getText()));
    }

    @Override
    public void exitComparisonPredicate(@NotNull PQL2Parser.ComparisonPredicateContext ctx) {
        this.popNode();
    }

    @Override
    public void enterExpressionParenthesisGroup(@NotNull PQL2Parser.ExpressionParenthesisGroupContext ctx) {
        this.pushNode(new ExpressionParenthesisGroupAstNode());
    }

    @Override
    public void exitExpressionParenthesisGroup(@NotNull PQL2Parser.ExpressionParenthesisGroupContext ctx) {
        this.popNode();
    }

    @Override
    public void enterOutputColumn(@NotNull PQL2Parser.OutputColumnContext ctx) {
        this.pushNode(new OutputColumnAstNode());
    }

    @Override
    public void exitOutputColumn(@NotNull PQL2Parser.OutputColumnContext ctx) {
        this.popNode();
    }

    @Override
    public void enterIdentifier(@NotNull PQL2Parser.IdentifierContext ctx) {
        this.pushNode(new IdentifierAstNode(ctx.getText()));
    }

    @Override
    public void exitIdentifier(@NotNull PQL2Parser.IdentifierContext ctx) {
        this.popNode();
    }

    @Override
    public void enterStarExpression(@NotNull PQL2Parser.StarExpressionContext ctx) {
        this.pushNode(new StarExpressionAstNode());
    }

    @Override
    public void exitStarExpression(@NotNull PQL2Parser.StarExpressionContext ctx) {
        this.popNode();
    }

    @Override
    public void enterFunctionCall(@NotNull PQL2Parser.FunctionCallContext ctx) {
        String expression = this._expression.substring(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex() + 1);
        this.pushNode(new FunctionCallAstNode(ctx.getChild(0).getText(), expression));
    }

    @Override
    public void exitFunctionCall(@NotNull PQL2Parser.FunctionCallContext ctx) {
        this.popNode();
    }

    @Override
    public void enterIntegerLiteral(@NotNull PQL2Parser.IntegerLiteralContext ctx) {
        this.pushNode(new IntegerLiteralAstNode(Long.parseLong(ctx.getText())));
    }

    @Override
    public void exitIntegerLiteral(@NotNull PQL2Parser.IntegerLiteralContext ctx) {
        this.popNode();
    }

    @Override
    public void enterOrderBy(@NotNull PQL2Parser.OrderByContext ctx) {
        this.pushNode(new OrderByAstNode());
    }

    @Override
    public void exitOrderBy(@NotNull PQL2Parser.OrderByContext ctx) {
        this.popNode();
    }

    @Override
    public void enterGroupBy(@NotNull PQL2Parser.GroupByContext ctx) {
        this.pushNode(new GroupByAstNode());
    }

    @Override
    public void exitGroupBy(@NotNull PQL2Parser.GroupByContext ctx) {
        this.popNode();
    }

    @Override
    public void enterBetweenPredicate(@NotNull PQL2Parser.BetweenPredicateContext ctx) {
        this.pushNode(new BetweenPredicateAstNode());
    }

    @Override
    public void exitBetweenPredicate(@NotNull PQL2Parser.BetweenPredicateContext ctx) {
        this.popNode();
    }

    @Override
    public void enterBinaryMathOp(@NotNull PQL2Parser.BinaryMathOpContext ctx) {
        this.pushNode(new BinaryMathOpAstNode(ctx.getChild(1).getText()));
    }

    @Override
    public void exitBinaryMathOp(@NotNull PQL2Parser.BinaryMathOpContext ctx) {
        this.popNode();
    }

    @Override
    public void enterInPredicate(@NotNull PQL2Parser.InPredicateContext ctx) {
        boolean isNotInClause = false;
        if ("not".equalsIgnoreCase(ctx.getChild(0).getChild(1).getText())) {
            isNotInClause = true;
        }
        this.pushNode(new InPredicateAstNode(isNotInClause));
    }

    @Override
    public void exitInPredicate(@NotNull PQL2Parser.InPredicateContext ctx) {
        this.popNode();
    }

    @Override
    public void enterRegexpLikePredicate(@NotNull PQL2Parser.RegexpLikePredicateContext ctx) {
        this.pushNode(new RegexpLikePredicateAstNode());
    }

    @Override
    public void exitRegexpLikePredicate(@NotNull PQL2Parser.RegexpLikePredicateContext ctx) {
        this.popNode();
    }

    @Override
    public void enterHaving(@NotNull PQL2Parser.HavingContext ctx) {
        this.pushNode(new HavingAstNode());
    }

    @Override
    public void exitHaving(@NotNull PQL2Parser.HavingContext ctx) {
        this.popNode();
    }

    @Override
    public void enterStringLiteral(@NotNull PQL2Parser.StringLiteralContext ctx) {
        String text = ctx.getText();
        int textLength = text.length();
        String literalWithoutQuotes = text.substring(1, textLength - 1);
        if (text.charAt(0) == '\'') {
            if (literalWithoutQuotes.contains("''")) {
                literalWithoutQuotes = literalWithoutQuotes.replaceAll("''", "'");
            }
            this.pushNode(new StringLiteralAstNode(literalWithoutQuotes));
        } else if (text.charAt(0) == '\"') {
            if (literalWithoutQuotes.contains("\"\"")) {
                literalWithoutQuotes = literalWithoutQuotes.replaceAll("\"\"", "\"");
            }
            this.pushNode(new StringLiteralAstNode(literalWithoutQuotes));
        } else {
            throw new Pql2CompilationException("String literal does not start with either '  or \"");
        }
    }

    @Override
    public void exitStringLiteral(@NotNull PQL2Parser.StringLiteralContext ctx) {
        this.popNode();
    }

    @Override
    public void enterFloatingPointLiteral(@NotNull PQL2Parser.FloatingPointLiteralContext ctx) {
        this.pushNode(new FloatingPointLiteralAstNode(Double.valueOf(ctx.getText())));
    }

    @Override
    public void exitFloatingPointLiteral(@NotNull PQL2Parser.FloatingPointLiteralContext ctx) {
        this.popNode();
    }

    @Override
    public void enterLimit(@NotNull PQL2Parser.LimitContext ctx) {
        if (ctx.getChild(0).getChildCount() == 2) {
            this.pushNode(new LimitAstNode(Integer.parseInt(ctx.getChild(0).getChild(1).getText())));
        } else {
            this.pushNode(new LimitAstNode(Integer.parseInt(ctx.getChild(0).getChild(3).getText()), Integer.parseInt(ctx.getChild(0).getChild(1).getText())));
        }
    }

    @Override
    public void exitLimit(@NotNull PQL2Parser.LimitContext ctx) {
        this.popNode();
    }

    @Override
    public void enterWhere(@NotNull PQL2Parser.WhereContext ctx) {
        this.pushNode(new WhereAstNode());
    }

    @Override
    public void exitWhere(@NotNull PQL2Parser.WhereContext ctx) {
        this.popNode();
    }

    @Override
    public void enterTopClause(@NotNull PQL2Parser.TopClauseContext ctx) {
        this.pushNode(new TopAstNode(Integer.parseInt(ctx.getChild(1).getText())));
    }

    @Override
    public void exitTopClause(@NotNull PQL2Parser.TopClauseContext ctx) {
        this.popNode();
    }

    @Override
    public void enterOrderByExpression(@NotNull PQL2Parser.OrderByExpressionContext ctx) {
        if (ctx.getChildCount() == 1) {
            this.pushNode(new OrderByExpressionAstNode(ctx.getChild(0).getText(), "asc"));
        } else {
            this.pushNode(new OrderByExpressionAstNode(ctx.getChild(0).getText(), ctx.getChild(1).getText()));
        }
    }

    @Override
    public void exitOrderByExpression(@NotNull PQL2Parser.OrderByExpressionContext ctx) {
        this.popNode();
    }

    @Override
    public void enterPredicateList(@NotNull PQL2Parser.PredicateListContext ctx) {
        this.pushNode(new PredicateListAstNode());
    }

    @Override
    public void exitPredicateList(@NotNull PQL2Parser.PredicateListContext ctx) {
        this.popNode();
    }

    @Override
    public void enterBooleanOperator(@NotNull PQL2Parser.BooleanOperatorContext ctx) {
        this.pushNode(BooleanOperatorAstNode.valueOf(ctx.getText().toUpperCase()));
    }

    @Override
    public void exitBooleanOperator(@NotNull PQL2Parser.BooleanOperatorContext ctx) {
        this.popNode();
    }

    @Override
    public void enterOption(PQL2Parser.OptionContext ctx) {
        this.pushNode(new OptionAstNode());
    }

    @Override
    public void exitOption(PQL2Parser.OptionContext ctx) {
        this.popNode();
    }

    @Override
    public void enterOptions(PQL2Parser.OptionsContext ctx) {
        this.pushNode(new OptionsAstNode());
    }

    @Override
    public void exitOptions(PQL2Parser.OptionsContext ctx) {
        this.popNode();
    }
}

