/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.pql.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.antlr.v4.runtime.ANTLRInputStream;
import org.apache.pinot.$internal.org.antlr.v4.runtime.BailErrorStrategy;
import org.apache.pinot.$internal.org.antlr.v4.runtime.BaseErrorListener;
import org.apache.pinot.$internal.org.antlr.v4.runtime.CommonTokenFactory;
import org.apache.pinot.$internal.org.antlr.v4.runtime.RecognitionException;
import org.apache.pinot.$internal.org.antlr.v4.runtime.Recognizer;
import org.apache.pinot.$internal.org.antlr.v4.runtime.UnbufferedTokenStream;
import org.apache.pinot.$internal.org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.pinot.$internal.org.apache.commons.lang.math.NumberUtils;
import org.apache.pinot.$internal.org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.AbstractCompiler;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.PQL2Lexer;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.PQL2Parser;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.Pql2AstListener;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.BaseAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.BetweenPredicateAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.ComparisonPredicateAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.HavingAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.InPredicateAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.OutputColumnAstNode;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.transform.TransformExpressionTree;

@ThreadSafe
public class Pql2Compiler
implements AbstractCompiler {
    private static final ErrorListener ERROR_LISTENER = new ErrorListener();

    @Override
    public BrokerRequest compileToBrokerRequest(String expression) throws Pql2CompilationException {
        try {
            ANTLRInputStream charStream = new ANTLRInputStream(expression);
            PQL2Lexer lexer = new PQL2Lexer(charStream);
            lexer.setTokenFactory(new CommonTokenFactory(true));
            lexer.removeErrorListeners();
            lexer.addErrorListener(ERROR_LISTENER);
            UnbufferedTokenStream tokenStream = new UnbufferedTokenStream(lexer);
            PQL2Parser parser = new PQL2Parser(tokenStream);
            parser.setErrorHandler(new BailErrorStrategy());
            parser.removeErrorListeners();
            parser.addErrorListener(ERROR_LISTENER);
            PQL2Parser.RootContext parseTree = parser.root();
            ParseTreeWalker walker = new ParseTreeWalker();
            Pql2AstListener listener = new Pql2AstListener(expression);
            walker.walk(listener, parseTree);
            AstNode rootNode = listener.getRootNode();
            this.validateHavingClause(rootNode);
            BrokerRequest brokerRequest = new BrokerRequest();
            rootNode.updateBrokerRequest(brokerRequest);
            return brokerRequest;
        }
        catch (Pql2CompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Pql2CompilationException(ExceptionUtils.getStackTrace(e));
        }
    }

    @Override
    public TransformExpressionTree compileToExpressionTree(String expression) {
        ANTLRInputStream charStream = new ANTLRInputStream(expression);
        PQL2Lexer lexer = new PQL2Lexer(charStream);
        lexer.setTokenFactory(new CommonTokenFactory(true));
        UnbufferedTokenStream tokenStream = new UnbufferedTokenStream(lexer);
        PQL2Parser parser = new PQL2Parser(tokenStream);
        parser.setErrorHandler(new BailErrorStrategy());
        PQL2Parser.ExpressionContext parseTree = parser.expression();
        ParseTreeWalker walker = new ParseTreeWalker();
        Pql2AstListener listener = new Pql2AstListener(expression);
        walker.walk(listener, parseTree);
        return new TransformExpressionTree(listener.getRootNode());
    }

    private void validateHavingClause(AstNode rootNode) {
        List<? extends AstNode> children = rootNode.getChildren();
        BaseAstNode outList = (BaseAstNode)children.get(0);
        HavingAstNode havingList = null;
        boolean isThereHaving = false;
        for (int i = 1; i < children.size(); ++i) {
            if (!(children.get(i) instanceof HavingAstNode)) continue;
            havingList = (HavingAstNode)children.get(i);
            isThereHaving = true;
            break;
        }
        if (isThereHaving) {
            List<FunctionCallAstNode> functionCalls = this.havingTreeDFSTraversalToFindFunctionCalls(havingList);
            if (functionCalls.isEmpty()) {
                throw new Pql2CompilationException("HAVING clause needs to have minimum one function call comparison");
            }
            List<? extends AstNode> outListChildren = outList.getChildren();
            for (FunctionCallAstNode havingFunction : functionCalls) {
                boolean functionCallIsInSelectList = false;
                for (AstNode astNode : outListChildren) {
                    FunctionCallAstNode function;
                    OutputColumnAstNode selectItem = (OutputColumnAstNode)astNode;
                    if (!(selectItem.getChildren().get(0) instanceof FunctionCallAstNode) || !(function = (FunctionCallAstNode)selectItem.getChildren().get(0)).getExpression().equalsIgnoreCase(havingFunction.getExpression()) || !function.getName().equalsIgnoreCase(havingFunction.getName())) continue;
                    functionCallIsInSelectList = true;
                    break;
                }
                if (functionCallIsInSelectList) continue;
                OutputColumnAstNode havingFunctionAstNode = new OutputColumnAstNode();
                havingFunction.setIsInSelectList(false);
                havingFunctionAstNode.addChild(havingFunction);
                havingFunction.setParent(havingFunctionAstNode);
                outList.addChild(havingFunctionAstNode);
                havingFunctionAstNode.setParent(outList);
            }
        }
    }

    private List<FunctionCallAstNode> havingTreeDFSTraversalToFindFunctionCalls(HavingAstNode havingList) {
        ArrayList<FunctionCallAstNode> functionCalls = new ArrayList<FunctionCallAstNode>();
        Stack<AstNode> astNodeStack = new Stack<AstNode>();
        astNodeStack.add(havingList);
        while (!astNodeStack.isEmpty()) {
            AstNode visitingNode = (AstNode)astNodeStack.pop();
            if (visitingNode instanceof ComparisonPredicateAstNode) {
                if (!((ComparisonPredicateAstNode)visitingNode).isItFunctionCallComparison()) {
                    throw new Pql2CompilationException("Having predicate only compares function calls");
                }
                if (!NumberUtils.isNumber(((ComparisonPredicateAstNode)visitingNode).getValue())) {
                    throw new Pql2CompilationException("Having clause only supports comparing function result with numbers");
                }
                functionCalls.add(((ComparisonPredicateAstNode)visitingNode).getFunction());
                continue;
            }
            if (visitingNode instanceof BetweenPredicateAstNode) {
                if (!((BetweenPredicateAstNode)visitingNode).isItFunctionCallComparison()) {
                    throw new Pql2CompilationException("Having predicate only compares function calls");
                }
                if (!NumberUtils.isNumber(((BetweenPredicateAstNode)visitingNode).getLeftValue())) {
                    throw new Pql2CompilationException("Having clause only supports comparing function result with numbers");
                }
                if (!NumberUtils.isNumber(((BetweenPredicateAstNode)visitingNode).getRightValue())) {
                    throw new Pql2CompilationException("Having clause only supports comparing function result with numbers");
                }
                functionCalls.add(((BetweenPredicateAstNode)visitingNode).getFunction());
                continue;
            }
            if (visitingNode instanceof InPredicateAstNode) {
                if (!((InPredicateAstNode)visitingNode).isItFunctionCallComparison()) {
                    throw new Pql2CompilationException("Having predicate only compares function calls");
                }
                for (String string : ((InPredicateAstNode)visitingNode).getValues()) {
                    if (NumberUtils.isNumber(string)) continue;
                    throw new Pql2CompilationException("Having clause only supports comparing function result with numbers");
                }
                functionCalls.add(((InPredicateAstNode)visitingNode).getFunction());
                continue;
            }
            if (visitingNode instanceof .RegexpLikePredicateAstNode) {
                throw new Pql2CompilationException("Having predicate does not support regular expression");
            }
            if (!visitingNode.hasChildren()) continue;
            for (AstNode astNode : visitingNode.getChildren()) {
                astNodeStack.add(astNode);
            }
        }
        return functionCalls;
    }

    private static class ErrorListener
    extends BaseErrorListener {
        private ErrorListener() {
        }

        @Override
        public void syntaxError(@Nonnull Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, @Nonnull String msg, @Nullable RecognitionException e) {
            throw new Pql2CompilationException(msg, offendingSymbol, line, charPositionInLine, e);
        }
    }
}

