/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast;

import java.util.Collections;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.LiteralAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.PredicateAstNode;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.HavingQueryTree;

public class ComparisonPredicateAstNode
extends PredicateAstNode {
    private String _operand;
    private LiteralAstNode _literal;

    public ComparisonPredicateAstNode(String operand) {
        this._operand = operand;
    }

    public String getOperand() {
        return this._operand;
    }

    public String getValue() {
        return this._literal.getValueAsString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addChild(AstNode childNode) {
        block10: {
            if (childNode instanceof IdentifierAstNode) {
                if (this._identifier == null && this._function == null) {
                    this._identifier = ((IdentifierAstNode)childNode).getName();
                    break block10;
                } else {
                    if (this._identifier != null) {
                        throw new Pql2CompilationException("Comparison between two columns is not supported.");
                    }
                    throw new Pql2CompilationException("Comparison between function and column is not supported.");
                }
            }
            if (childNode instanceof FunctionCallAstNode) {
                if (this._function == null && this._identifier == null) {
                    this._function = (FunctionCallAstNode)childNode;
                    break block10;
                } else {
                    if (this._function != null) {
                        throw new Pql2CompilationException("Comparison between two functions is not supported.");
                    }
                    throw new Pql2CompilationException("Comparison between column and function is not supported.");
                }
            }
            if (childNode instanceof LiteralAstNode) {
                LiteralAstNode node = (LiteralAstNode)childNode;
                if (this._literal != null) {
                    throw new Pql2CompilationException("Comparison between two constants is not supported.");
                }
                this._literal = node;
            }
        }
        super.addChild(childNode);
    }

    @Override
    public String toString() {
        return "ComparisonPredicateAstNode{_operand='" + this._operand + '\'' + '}';
    }

    private String createRangeStringForComparison() {
        String comparison = null;
        String value = this._literal.getValueAsString();
        boolean identifierIsOnLeft = true;
        if (this.getChildren().get(0) instanceof LiteralAstNode) {
            identifierIsOnLeft = false;
        }
        if ("<".equals(this._operand)) {
            comparison = identifierIsOnLeft ? "(*\t\t" + value + ")" : "(" + value + "\t\t*)";
        } else if ("<=".equals(this._operand)) {
            comparison = identifierIsOnLeft ? "(*\t\t" + value + "]" : "[" + value + "\t\t*)";
        } else if (">".equals(this._operand)) {
            comparison = identifierIsOnLeft ? "(" + value + "\t\t*)" : "(*\t\t" + value + "*)";
        } else if (">=".equals(this._operand)) {
            comparison = identifierIsOnLeft ? "[" + value + "\t\t*)" : "(*\t\t" + value + "*)";
        }
        return comparison;
    }

    @Override
    public FilterQueryTree buildFilterQueryTree() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("Comparison predicate has no identifier");
        }
        if ("=".equals(this._operand)) {
            if (this._identifier != null && this._literal != null) {
                return new FilterQueryTree(this._identifier, Collections.singletonList(this._literal.getValueAsString()), FilterOperator.EQUALITY, null);
            }
            throw new Pql2CompilationException("Comparison is not between a column and a constant");
        }
        if ("<>".equals(this._operand) || "!=".equals(this._operand)) {
            if (this._identifier != null && this._literal != null) {
                return new FilterQueryTree(this._identifier, Collections.singletonList(this._literal.getValueAsString()), FilterOperator.NOT, null);
            }
            throw new Pql2CompilationException("Comparison is not between a column and a constant");
        }
        String comparison = this.createRangeStringForComparison();
        if (comparison == null) {
            throw new Pql2CompilationException("The comparison operator is not valid/is not supported for HAVING query");
        }
        if (this._identifier != null) {
            return new FilterQueryTree(this._identifier, Collections.singletonList(comparison), FilterOperator.RANGE, null);
        }
        throw new Pql2CompilationException("One column is needed for comparison.");
    }

    @Override
    public HavingQueryTree buildHavingQueryTree() {
        if (this._function == null) {
            throw new Pql2CompilationException("Comparison predicate has no function");
        }
        if ("=".equals(this._operand)) {
            if (this._function != null && this._literal != null) {
                return new HavingQueryTree(this._function.buildAggregationInfo(), Collections.singletonList(this._literal.getValueAsString()), FilterOperator.EQUALITY, null);
            }
            throw new Pql2CompilationException("Comparison is not between a function and a constant");
        }
        if ("<>".equals(this._operand) || "!=".equals(this._operand)) {
            if (this._function != null && this._literal != null) {
                return new HavingQueryTree(this._function.buildAggregationInfo(), Collections.singletonList(this._literal.getValueAsString()), FilterOperator.NOT, null);
            }
            throw new Pql2CompilationException("Comparison is not between a function and a constant");
        }
        String comparison = this.createRangeStringForComparison();
        if (this._function != null) {
            return new HavingQueryTree(this._function.buildAggregationInfo(), Collections.singletonList(comparison), FilterOperator.RANGE, null);
        }
        throw new Pql2CompilationException("Function call is needed for comparison.");
    }
}

