/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.LiteralAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.PredicateAstNode;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.HavingQueryTree;

public class InPredicateAstNode
extends PredicateAstNode {
    private final boolean _isNotInClause;

    public InPredicateAstNode(boolean isNotInClause) {
        this._isNotInClause = isNotInClause;
    }

    public ArrayList<String> getValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (AstNode astNode : this.getChildren()) {
            if (!(astNode instanceof LiteralAstNode)) continue;
            LiteralAstNode node = (LiteralAstNode)astNode;
            values.add(node.getValueAsString());
        }
        return values;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addChild(AstNode childNode) {
        if (childNode instanceof IdentifierAstNode) {
            if (this._identifier == null && this._function == null) {
                IdentifierAstNode node = (IdentifierAstNode)childNode;
                this._identifier = node.getName();
                return;
            }
            if (this._identifier == null) throw new Pql2CompilationException("IN predicate has both identifier and function.");
            throw new Pql2CompilationException("IN predicate has more than one identifier.");
        }
        if (!(childNode instanceof FunctionCallAstNode)) {
            super.addChild(childNode);
            return;
        }
        if (this._function == null && this._identifier == null) {
            this._function = (FunctionCallAstNode)childNode;
            return;
        }
        if (this._function == null) throw new Pql2CompilationException("IN predicate has both identifier and function.");
        throw new Pql2CompilationException("IN predicate has more than one function.");
    }

    @Override
    public String toString() {
        if (this._identifier != null) {
            return "InPredicateAstNode{_identifier='" + this._identifier + '\'' + '}';
        }
        if (this._function != null) {
            return "InPredicateAstNode{_function='" + this._function.toString() + '\'' + '}';
        }
        return "InPredicateAstNode{_identifier/_function= null";
    }

    @Override
    public FilterQueryTree buildFilterQueryTree() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("IN predicate has no identifier");
        }
        HashSet<String> values = new HashSet<String>();
        for (AstNode astNode : this.getChildren()) {
            if (!(astNode instanceof LiteralAstNode)) continue;
            LiteralAstNode node = (LiteralAstNode)astNode;
            values.add(node.getValueAsString());
        }
        FilterOperator filterOperator = this._isNotInClause ? FilterOperator.NOT_IN : FilterOperator.IN;
        return new FilterQueryTree(this._identifier, new ArrayList<String>(values), filterOperator, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HavingQueryTree buildHavingQueryTree() {
        void var3_6;
        if (this._function == null) {
            throw new Pql2CompilationException("IN predicate has no function");
        }
        TreeSet<String> values = new TreeSet<String>();
        for (AstNode astNode : this.getChildren()) {
            if (!(astNode instanceof LiteralAstNode)) continue;
            LiteralAstNode node = (LiteralAstNode)astNode;
            values.add(node.getValueAsString());
        }
        String[] valueArray = values.toArray(new String[values.size()]);
        if (this._isNotInClause) {
            FilterOperator filterOperator = FilterOperator.NOT_IN;
        } else {
            FilterOperator filterOperator = FilterOperator.IN;
        }
        return new HavingQueryTree(this._function.buildAggregationInfo(), Collections.singletonList(StringUtil.join("\t\t", valueArray)), (FilterOperator)var3_6, null);
    }
}

