/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast;

import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.BaseAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.LiteralAstNode;
import org.apache.pinot.common.request.BrokerRequest;

public class OptionAstNode
extends BaseAstNode {
    @Override
    public void updateBrokerRequest(BrokerRequest brokerRequest) {
        String right;
        if (this.getChildren().size() != 2) {
            throw new Pql2CompilationException("Expected exactly two children for OptionAstNode");
        }
        AstNode leftNode = this.getChildren().get(0);
        AstNode rightNode = this.getChildren().get(1);
        if (!(leftNode instanceof IdentifierAstNode)) {
            throw new Pql2CompilationException("Expected left child node of OptionAstNode to be an identifier");
        }
        String left = ((IdentifierAstNode)leftNode).getExpression();
        if (rightNode instanceof IdentifierAstNode) {
            right = ((IdentifierAstNode)rightNode).getExpression();
        } else if (rightNode instanceof LiteralAstNode) {
            right = ((LiteralAstNode)rightNode).getValueAsString();
        } else {
            throw new Pql2CompilationException("Right node of OptionAstNode is neither an identifier nor a literal");
        }
        brokerRequest.getQueryOptions().put(left, right);
    }
}

