/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.BooleanOperatorAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.PredicateAstNode;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.HavingQueryTree;

public class PredicateListAstNode
extends PredicateAstNode {
    public void buildQueryTreePredicates(List<FilterQueryTree> filterQueryOrPredicates, List<FilterQueryTree> filterQueryAndPredicates, List<HavingQueryTree> havingQueryOrPredicates, List<HavingQueryTree> havingQueryAndPredicates, boolean isItHaving) {
        int childrenCount = this.getChildren().size();
        for (int i = 0; i < childrenCount; i += 2) {
            PredicateAstNode predicate = (PredicateAstNode)this.getChildren().get(i);
            BooleanOperatorAstNode nextOperator = null;
            if (i + 1 < childrenCount) {
                nextOperator = (BooleanOperatorAstNode)this.getChildren().get(i + 1);
            }
            if (!isItHaving) {
                if (nextOperator == null) {
                    if (!filterQueryAndPredicates.isEmpty()) {
                        filterQueryAndPredicates.add(predicate.buildFilterQueryTree());
                        if (filterQueryOrPredicates.isEmpty()) continue;
                        filterQueryOrPredicates.add(this.buildFilterPredicate(filterQueryAndPredicates, FilterOperator.AND));
                        continue;
                    }
                    filterQueryOrPredicates.add(predicate.buildFilterQueryTree());
                    continue;
                }
                if (nextOperator == BooleanOperatorAstNode.AND) {
                    filterQueryAndPredicates.add(predicate.buildFilterQueryTree());
                    continue;
                }
                if (!filterQueryAndPredicates.isEmpty()) {
                    filterQueryAndPredicates.add(predicate.buildFilterQueryTree());
                    filterQueryOrPredicates.add(this.buildFilterPredicate(filterQueryAndPredicates, FilterOperator.AND));
                    filterQueryAndPredicates = new ArrayList<FilterQueryTree>();
                    continue;
                }
                filterQueryOrPredicates.add(predicate.buildFilterQueryTree());
                continue;
            }
            if (nextOperator == null) {
                if (!havingQueryAndPredicates.isEmpty()) {
                    havingQueryAndPredicates.add(predicate.buildHavingQueryTree());
                    if (havingQueryOrPredicates.isEmpty()) continue;
                    havingQueryOrPredicates.add(this.buildHavingPredicate(havingQueryAndPredicates, FilterOperator.AND));
                    continue;
                }
                havingQueryOrPredicates.add(predicate.buildHavingQueryTree());
                continue;
            }
            if (nextOperator == BooleanOperatorAstNode.AND) {
                havingQueryAndPredicates.add(predicate.buildHavingQueryTree());
                continue;
            }
            if (!havingQueryAndPredicates.isEmpty()) {
                havingQueryAndPredicates.add(predicate.buildHavingQueryTree());
                havingQueryOrPredicates.add(this.buildHavingPredicate(havingQueryAndPredicates, FilterOperator.AND));
                havingQueryAndPredicates = new ArrayList<HavingQueryTree>();
                continue;
            }
            havingQueryOrPredicates.add(predicate.buildHavingQueryTree());
        }
    }

    @Override
    public FilterQueryTree buildFilterQueryTree() {
        ArrayList<FilterQueryTree> orPredicates = new ArrayList<FilterQueryTree>();
        ArrayList<FilterQueryTree> andPredicates = new ArrayList<FilterQueryTree>();
        int childrenCount = this.getChildren().size();
        if (childrenCount == 1) {
            return ((PredicateAstNode)this.getChildren().get(0)).buildFilterQueryTree();
        }
        this.buildQueryTreePredicates(orPredicates, andPredicates, null, null, false);
        if (!orPredicates.isEmpty()) {
            return this.buildFilterPredicate(orPredicates, FilterOperator.OR);
        }
        return this.buildFilterPredicate(andPredicates, FilterOperator.AND);
    }

    @Override
    public HavingQueryTree buildHavingQueryTree() {
        ArrayList<HavingQueryTree> orPredicates = new ArrayList<HavingQueryTree>();
        ArrayList<HavingQueryTree> andPredicates = new ArrayList<HavingQueryTree>();
        int childrenCount = this.getChildren().size();
        if (childrenCount == 1) {
            return ((PredicateAstNode)this.getChildren().get(0)).buildHavingQueryTree();
        }
        this.buildQueryTreePredicates(null, null, orPredicates, andPredicates, true);
        if (!orPredicates.isEmpty()) {
            return this.buildHavingPredicate(orPredicates, FilterOperator.OR);
        }
        return this.buildHavingPredicate(andPredicates, FilterOperator.AND);
    }

    private FilterQueryTree buildFilterPredicate(List<FilterQueryTree> children, FilterOperator operator) {
        return new FilterQueryTree(null, null, operator, children);
    }

    private HavingQueryTree buildHavingPredicate(List<HavingQueryTree> children, FilterOperator operator) {
        return new HavingQueryTree(null, null, operator, children);
    }
}

