/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.CompositeFuture;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.ServerResponseFuture;
import org.apache.pinot.common.response.ServerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompositeListenableFuture<T>
implements ServerResponseFuture<T> {
    protected static Logger LOGGER = LoggerFactory.getLogger(CompositeFuture.class);
    private final Lock _futureLock = new ReentrantLock();
    protected volatile CountDownLatch _latch;
    protected State _state;
    private final List<Runnable> _pendingRunnable = new ArrayList<Runnable>();
    private final List<Executor> _pendingRunnableExecutors = new ArrayList<Executor>();

    public AbstractCompositeListenableFuture() {
        this._state = State.PENDING;
    }

    protected synchronized boolean start() {
        if (this._state != State.PENDING) {
            return false;
        }
        this._state = State.STARTED;
        return true;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            this._futureLock.lock();
            if (this._state.isCompleted()) {
                LOGGER.info("Request is no longer pending. Cannot cancel !!");
                boolean bl = false;
                return bl;
            }
            this.setDone(State.CANCELLED);
        }
        finally {
            this._futureLock.unlock();
        }
        this.cancelUnderlyingFutures();
        return true;
    }

    protected abstract void cancelUnderlyingFutures();

    @Override
    public boolean isCancelled() {
        return this._state == State.CANCELLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDone(State state) {
        LOGGER.debug("Setting state to :" + (Object)((Object)state) + ", Current State :" + (Object)((Object)this._state));
        try {
            this._futureLock.lock();
            this._state = state;
            long count = this._latch.getCount();
            for (long i = 0L; i < count; ++i) {
                this._latch.countDown();
            }
        }
        finally {
            this._futureLock.unlock();
        }
        for (int i = 0; i < this._pendingRunnable.size(); ++i) {
            LOGGER.info("Running pending runnable :" + i);
            Executor e = this._pendingRunnableExecutors.get(i);
            if (null != e) {
                e.execute(this._pendingRunnable.get(i));
                continue;
            }
            this._pendingRunnable.get(i).run();
        }
        this._pendingRunnable.clear();
        this._pendingRunnableExecutors.clear();
    }

    @Override
    public boolean isDone() {
        return this._state.isCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Runnable listener, Executor executor) {
        boolean processed = false;
        try {
            this._futureLock.lock();
            if (!this._state.isCompleted()) {
                this._pendingRunnable.add(listener);
                this._pendingRunnableExecutors.add(executor);
                processed = true;
            }
        }
        finally {
            this._futureLock.unlock();
        }
        if (!processed) {
            LOGGER.info("Executing the listener as the future event is already done !!");
            if (null != executor) {
                executor.execute(listener);
            } else {
                listener.run();
            }
        }
    }

    protected abstract boolean processFutureResult(ServerInstance var1, Map<ServerInstance, T> var2, Map<ServerInstance, Throwable> var3, long var4);

    protected void addResponseFutureListener(ServerResponseFuture<T> future) {
        future.addListener(new ResponseFutureListener(future), null);
    }

    private class ResponseFutureListener
    implements Runnable {
        private final ServerResponseFuture<T> _future;

        public ResponseFutureListener(ServerResponseFuture<T> future) {
            this._future = future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.debug("Running Future Listener for underlying future for {}", (Object)this._future.getName());
            try {
                AbstractCompositeListenableFuture.this._futureLock.lock();
                if (AbstractCompositeListenableFuture.this._state.isCompleted()) {
                    return;
                }
            }
            finally {
                AbstractCompositeListenableFuture.this._futureLock.unlock();
            }
            Map response = null;
            try {
                response = (Map)this._future.get();
            }
            catch (InterruptedException e) {
                LOGGER.info("Got interrupted waiting for response", (Throwable)e);
            }
            catch (ExecutionException e) {
                LOGGER.info("Got execution exception waiting for response", (Throwable)e);
            }
            Map<ServerInstance, Throwable> error = this._future.getError();
            boolean done = AbstractCompositeListenableFuture.this.processFutureResult(this._future.getServerInstance(), response, error, this._future.getDurationMillis());
            if (done) {
                AbstractCompositeListenableFuture.this.setDone(State.DONE);
                AbstractCompositeListenableFuture.this.cancelUnderlyingFutures();
            }
            try {
                AbstractCompositeListenableFuture.this._futureLock.lock();
                if (AbstractCompositeListenableFuture.this._latch.getCount() == 1L && !done) {
                    AbstractCompositeListenableFuture.this.setDone(State.DONE);
                } else if (!done) {
                    AbstractCompositeListenableFuture.this._latch.countDown();
                }
            }
            finally {
                AbstractCompositeListenableFuture.this._futureLock.unlock();
            }
        }
    }

    private static enum State {
        PENDING,
        STARTED,
        CANCELLED,
        DONE;


        public boolean isCompleted() {
            return this != PENDING && this != STARTED;
        }
    }
}

