/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.Callback;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.Cancellable;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.ServerResponseFuture;
import org.apache.pinot.common.response.ServerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResponseFuture<T>
implements Callback<T>,
ServerResponseFuture<T> {
    protected static Logger LOGGER = LoggerFactory.getLogger(AsyncResponseFuture.class);
    private Cancellable _cancellable;
    private final ServerInstance _key;
    private final Lock _futureLock = new ReentrantLock();
    private final Condition _finished = this._futureLock.newCondition();
    private volatile T _delayedResponse;
    private volatile Throwable _error;
    private final List<Runnable> _pendingRunnable = new ArrayList<Runnable>();
    private final List<Executor> _pendingRunnableExecutors = new ArrayList<Executor>();
    private volatile Map<ServerInstance, T> _responseMap;
    private volatile Map<ServerInstance, Throwable> _errorMap;
    private final String _ctxt;
    private final long _startTime;
    private long _endTime;
    private State _state;

    public AsyncResponseFuture(ServerInstance key, String ctxt) {
        this._key = key;
        this._state = State.PENDING;
        this._cancellable = new NoopCancellable();
        this._ctxt = ctxt;
        this._startTime = System.currentTimeMillis();
    }

    public AsyncResponseFuture(ServerInstance key, Throwable t, String ctxt) {
        this._key = key;
        this._state = State.DONE;
        this._error = t;
        this._ctxt = ctxt;
        this._startTime = System.currentTimeMillis();
    }

    public void setCancellable(Cancellable cancellable) {
        this._cancellable = cancellable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean isCancelled = false;
        try {
            this._futureLock.lock();
            if (this._state.isCompleted()) {
                LOGGER.info("{} Request is no longer pending. Cannot cancel !!", (Object)this._ctxt);
                boolean bl = false;
                return bl;
            }
            isCancelled = this._cancellable.cancel();
            if (isCancelled) {
                this.setDone(State.CANCELLED);
            }
        }
        finally {
            this._futureLock.unlock();
        }
        return isCancelled;
    }

    @Override
    public void onSuccess(T result) {
        try {
            this._futureLock.lock();
            if (this._state.isCompleted()) {
                LOGGER.debug("{} Request has already been completed. Discarding this response !!", (Object)this._ctxt, result);
                return;
            }
            this._delayedResponse = result;
            this.setDone(State.DONE);
        }
        finally {
            this._futureLock.unlock();
        }
    }

    @Override
    public void onError(Throwable t) {
        try {
            this._futureLock.lock();
            if (this._state.isCompleted()) {
                LOGGER.debug("{} Request has already been completed. Discarding error message !!", (Object)this._ctxt, (Object)t);
                return;
            }
            this._error = t;
            this.setDone(State.DONE);
        }
        finally {
            this._futureLock.unlock();
        }
    }

    @Override
    public boolean isCancelled() {
        return this._state == State.CANCELLED;
    }

    @Override
    public boolean isDone() {
        return this._state.isCompleted();
    }

    @Override
    public Map<ServerInstance, T> get() throws InterruptedException, ExecutionException {
        try {
            this._futureLock.lock();
            while (!this._state.isCompleted()) {
                this._finished.await();
            }
            if (null == this._responseMap) {
                this.setResponseMap();
            }
        }
        finally {
            this._futureLock.unlock();
        }
        return this._responseMap;
    }

    @Override
    public T getOne() throws InterruptedException, ExecutionException {
        try {
            this._futureLock.lock();
            while (!this._state.isCompleted()) {
                this._finished.await();
            }
        }
        finally {
            this._futureLock.unlock();
        }
        return this._delayedResponse;
    }

    @Override
    public long getDurationMillis() {
        if (this._endTime > 0L) {
            return this._endTime - this._startTime;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getOne(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this._futureLock.lock();
            while (!this._state.isCompleted()) {
                boolean notElapsed = this._finished.await(timeout, unit);
                if (notElapsed) continue;
                throw new TimeoutException("Timedout waiting for async result for key " + this._key);
            }
        }
        finally {
            this._futureLock.unlock();
        }
        return this._delayedResponse;
    }

    @Override
    public Map<ServerInstance, Throwable> getError() {
        if (null == this._errorMap && null != this._error) {
            try {
                this._futureLock.lock();
                if (null == this._errorMap && null != this._error) {
                    this._errorMap = new HashMap<ServerInstance, Throwable>();
                    this._errorMap.put(this._key, this._error);
                }
            }
            finally {
                this._futureLock.unlock();
            }
        }
        return this._errorMap;
    }

    private void setResponseMap() {
        if (null != this._delayedResponse) {
            this._responseMap = new HashMap<ServerInstance, T>();
            this._responseMap.put(this._key, this._delayedResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ServerInstance, T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this._futureLock.lock();
            while (!this._state.isCompleted()) {
                boolean notElapsed = this._finished.await(timeout, unit);
                if (!notElapsed) {
                    throw new TimeoutException("Timeout awaiting response !!");
                }
                if (null != this._responseMap) continue;
                this.setResponseMap();
            }
        }
        finally {
            this._futureLock.unlock();
        }
        return this._responseMap;
    }

    private void setDone(State state) {
        LOGGER.debug("{} Setting state to : {}, Current State : {}", new Object[]{this._ctxt, state, this._state});
        this._endTime = System.currentTimeMillis();
        try {
            this._futureLock.lock();
            this._state = state;
            this._finished.signalAll();
        }
        finally {
            this._futureLock.unlock();
        }
        for (int i = 0; i < this._pendingRunnable.size(); ++i) {
            LOGGER.debug("{} Running pending runnable :" + i, (Object)this._ctxt);
            Executor e = this._pendingRunnableExecutors.get(i);
            if (null != e) {
                e.execute(this._pendingRunnable.get(i));
                continue;
            }
            this._pendingRunnable.get(i).run();
        }
        this._pendingRunnable.clear();
        this._pendingRunnableExecutors.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Runnable listener, Executor executor) {
        boolean processed = false;
        try {
            this._futureLock.lock();
            if (!this._state.isCompleted()) {
                this._pendingRunnable.add(listener);
                this._pendingRunnableExecutors.add(executor);
                processed = true;
            }
        }
        finally {
            this._futureLock.unlock();
        }
        if (!processed) {
            LOGGER.debug("{} Executing the listener as the future event is already done !!", (Object)this._ctxt);
            if (null != executor) {
                executor.execute(listener);
            } else {
                listener.run();
            }
        }
    }

    @Override
    public ServerInstance getServerInstance() {
        return this._key;
    }

    @Override
    public String getName() {
        return this._key.toString();
    }

    public State getState() {
        return this._state;
    }

    public static class NoopCancellable
    implements Cancellable {
        @Override
        public boolean cancel() {
            return true;
        }
    }

    public static enum State {
        PENDING,
        CANCELLED,
        DONE;


        public boolean isCompleted() {
            return this != PENDING;
        }
    }
}

