/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.common;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LinkedDequeue<T>
extends AbstractQueue<T>
implements Deque<T> {
    private Node<T> _head;
    private Node<T> _tail;
    private int _size;

    public LinkedDequeue() {
    }

    public LinkedDequeue(Collection<? extends T> collection) {
        this.addAll(collection);
    }

    public Node<T> addFirstNode(T item) {
        return this.addBeforeNode(this._head, item);
    }

    public Node<T> addLastNode(T item) {
        return this.addBeforeNode(null, item);
    }

    public Node<T> addBeforeNode(Node<T> before, T item) {
        if (item == null) {
            throw new NullPointerException();
        }
        if (before != null && before != this._head && ((Node)before)._next == null && ((Node)before)._prev == null) {
            throw new IllegalStateException("node was already removed");
        }
        Node node = new Node(item);
        if (before == null) {
            node._next = null;
            node._prev = (Node)this._tail;
            if (this._tail != null) {
                ((Node)this._tail)._next = node;
            }
            this._tail = node;
            if (this._head == null) {
                this._head = node;
            }
        } else {
            node._next = (Node)before;
            node._prev = ((Node)before)._prev;
            ((Node)before)._prev = node;
            if (before == this._head) {
                this._head = node;
            }
        }
        ++this._size;
        return node;
    }

    public T removeNode(Node<T> node) {
        if (node != this._head && ((Node)node)._next == null && ((Node)node)._prev == null) {
            return null;
        }
        if (node == this._head) {
            this._head = ((Node)node)._next;
        }
        if (((Node)node)._prev != null) {
            ((Node)node)._prev._next = ((Node)node)._next;
        }
        if (node == this._tail) {
            this._tail = ((Node)node)._prev;
        }
        if (((Node)node)._next != null) {
            ((Node)node)._next._prev = ((Node)node)._prev;
        }
        ((Node)node)._next = null;
        ((Node)node)._prev = null;
        --this._size;
        return (T)((Node)node)._value;
    }

    @Override
    public boolean offerFirst(T t) {
        this.addFirstNode(t);
        return true;
    }

    @Override
    public boolean offerLast(T t) {
        this.addLastNode(t);
        return true;
    }

    @Override
    public T peekFirst() {
        if (this._head == null) {
            return null;
        }
        return (T)((Node)this._head)._value;
    }

    @Override
    public T peekLast() {
        if (this._tail == null) {
            return null;
        }
        return (T)((Node)this._tail)._value;
    }

    @Override
    public T pollFirst() {
        if (this._head == null) {
            return null;
        }
        return this.removeNode(this._head);
    }

    @Override
    public T pollLast() {
        if (this._tail == null) {
            return null;
        }
        return this.removeNode(this._tail);
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public Iterator<T> iterator() {
        return new LinkedQueueIterator(Direction.ASCENDING);
    }

    @Override
    public Iterator<T> descendingIterator() {
        return new LinkedQueueIterator(Direction.DESCENDING);
    }

    @Override
    public void addFirst(T e) {
        if (!this.offerFirst(e)) {
            throw new IllegalStateException("Queue full");
        }
    }

    @Override
    public void addLast(T e) {
        if (!this.offerLast(e)) {
            throw new IllegalStateException("Queue full");
        }
    }

    @Override
    public T removeFirst() {
        T e = this.pollFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public T removeLast() {
        T e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public T getFirst() {
        T e = this.peekFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public T getLast() {
        T e = this.peekLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        Iterator<T> i = this.iterator();
        while (i.hasNext()) {
            if (!i.next().equals(o)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        Iterator<T> i = this.descendingIterator();
        while (i.hasNext()) {
            if (!i.next().equals(o)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    @Override
    public void push(T e) {
        this.addFirst(e);
    }

    @Override
    public T pop() {
        return this.removeFirst();
    }

    @Override
    public boolean offer(T e) {
        return this.offerLast(e);
    }

    @Override
    public T poll() {
        return this.pollFirst();
    }

    @Override
    public T peek() {
        return this.peekFirst();
    }

    private class LinkedQueueIterator
    implements Iterator<T> {
        private final Direction _dir;
        private Node<T> _index;
        private Node<T> _last;

        private LinkedQueueIterator(Direction dir) {
            this._dir = dir;
            this._index = this._dir == Direction.ASCENDING ? LinkedDequeue.this._head : LinkedDequeue.this._tail;
        }

        @Override
        public boolean hasNext() {
            return this._index != null;
        }

        @Override
        public T next() {
            if (this._index == null) {
                throw new NoSuchElementException();
            }
            this._last = this._index;
            Object value = this._index._value;
            this._index = this._dir == Direction.ASCENDING ? this._index._next : this._index._prev;
            return value;
        }

        @Override
        public void remove() {
            if (this._last == null) {
                throw new IllegalStateException();
            }
            LinkedDequeue.this.removeNode(this._last);
            this._last = null;
        }
    }

    private static enum Direction {
        ASCENDING,
        DESCENDING;

    }

    public static class Node<T> {
        private final T _value;
        private Node<T> _next;
        private Node<T> _prev;

        private Node(T value) {
            this._value = value;
        }
    }
}

